-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local currentMemorys = Input
local skip = Query.Skip or 0
local top = Query.Top or ((#currentMemorys - skip) > 32 and 32 or (#currentMemorys - skip))

local list = {}
if not currentMemorys or #currentMemorys == 0 then
    return list
end
if #currentMemorys <= tonumber(skip) then
    return list
end
for i = 1, top, 1 do
    if (#currentMemorys - skip - i + 1) > 0 then
        list[i] = currentMemorys[i + skip]
    end
end
return list