-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local req_obj = Input
req_obj.VLANId = tostring(req_obj.VLANId)
req_obj.VLANEnable = tostring(req_obj.VLANEnable)
if req_obj.Oem then
    if req_obj.Oem["{{OemIdentifier}}"] and req_obj.Oem["{{OemIdentifier}}"].IPv4Addresses then
        req_obj.IPv4Addresses = cjson.json_object_ordered_encode(req_obj.Oem["{{OemIdentifier}}"].IPv4Addresses)
    end
    if req_obj.Oem["{{OemIdentifier}}"] and req_obj.Oem["{{OemIdentifier}}"].IsOnBoot ~= nil then
        req_obj.OnBoot = req_obj.Oem["{{OemIdentifier}}"].IsOnBoot and "yes" or "no"
    end
    req_obj.Oem = nil
end

return req_obj
