-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local trap_server = Input[1]
local server_port = Input[2]
local mapping_table = cjson.json_object_new_array()

-- 只有ServiceType为Snmp的端口为Trap端口
local trap_server_port = {}
for _, port in ipairs(server_port) do
    if port.ServiceType == 'Snmp' then
        trap_server_port[#trap_server_port + 1] = port.VethPort
    end
end

for i = 1, 4 do
    local items_table = cjson.json_object_new_object()
    items_table['Id'] = trap_server[i]['MemberId']
    items_table['ServerAddress'] = trap_server[i]['TrapServerAddress']
    items_table['ServerPort'] = trap_server[i]['TrapServerPort']
    items_table['VethPort'] = trap_server_port[i]
    items_table['Enabled'] = trap_server[i]['Enabled']
    items_table['BobEnabled'] = trap_server[i]['BobEnabled']

    mapping_table[#mapping_table + 1] = items_table
end

return mapping_table
