-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local version = cjson.json_object_new_object()

version.APPVersion = ProcessingFlow[4].Destination.APPVersion
version.OSRevision = ProcessingFlow[4].Destination.OSRevision
version.DataVersion = ProcessingFlow[4].Destination.DataVersion
version.OSVersion = ProcessingFlow[4].Destination.OSVersion
version.MajorVersion = ProcessingFlow[4].Destination.MajorVersion

local msg = ProcessingFlow[4].Destination.ComponentsMessages
-- version.json 为空文件或其中没有 ComponentsMessages 字段时，msg 为空字符串，直接返回 version
if #msg == 0 then
    return version
end

local msg_json = cjson.json_object_ordered_decode(msg)
if not cjson.json_object_is_object(msg_json) then
    return version
end

for k, v in pairs(msg_json) do
    version[k] = v
end

return version
