-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sessions = Input
local count = 0
if sessions == nil then
    return nil
end
for i in pairs(sessions) do
    -- 当前kvm的sessiontype在资源树上为kvm(shared)或kvm(private)
    if string.sub(sessions[i].SessionType, 1, 3) == 'KVM' then
        count = count + 1
    end
end
if count == 0 then
    return nil
end

local mode = ProcessingFlow[3].Destination.SessionMode
if mode == 0 then
    return 'Shared'
elseif mode == 1 then
    return 'Private'
end

return nil