-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local model = ProcessingFlow[8].Destination.Model
local network_adapter_id = ProcessingFlow[8].Destination.ID
local port_id = Input
local port_list = {}
local uri_template = '/redfish/v1/Chassis/1/NetworkAdapters/%s/NetworkPorts/%s'
if model == 'NPU' then
    local port_npu_mapping = {
        [0] = {1, 9},
        [2] = {3, 11},
        [4] = {5, 13},
        [6] = {7, 15},
        [9] = {2, 10},
        [11] = {4, 12},
        [13] = {6, 14},
        [15] = {8, 16}
    }
    if port_npu_mapping[port_id] then
        port_list[1] = string.format(uri_template, network_adapter_id, port_npu_mapping[port_id][1])
        port_list[2] = string.format(uri_template, network_adapter_id, port_npu_mapping[port_id][2])
    end
else
    port_list[1] = string.format(uri_template, network_adapter_id, port_id + 1)
end

return port_list