-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local system_id_list = ProcessingFlow[2].Destination.CardForServers
local cpu_id = ProcessingFlow[9].Destination.SocketID
local path_list = {}

for _, path in pairs(system_id_list) do
    if path and cpu_id then
        path_list[#path_list + 1] = '/redfish/v1/Systems/' .. path .. '/Processors/' .. (cpu_id + 1)
    end
end

return path_list