-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local function format_data(data)
    if data == 65535 or data == nil then
        return cjson.null
    end
    return tonumber(string.format("%.4f", data))
end

local rx_power = {}
local current = ProcessingFlow[4].Destination.RXInputPowerMilliWatts
for i in pairs(current) do
    local temp = {
        ReadingMilliWatts = format_data(current[i]),
        LowerThresholdCritical = format_data(ProcessingFlow[4].Destination.RXLowerThresholdCritical),
        UpperThresholdCritical = format_data(ProcessingFlow[4].Destination.RXUpperThresholdCritical)
    }
    table.insert(rx_power, temp)
end
return rx_power