-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local addresses = {}
local NET_DEV_FUNC_TYPE_FC = 2
local function is_valid_mac(mac)
    return mac ~= '00:00:00:00:00:00' and mac ~= 'N/A'
end
if ProcessingFlow[2].Destination.NetDevFuncType == NET_DEV_FUNC_TYPE_FC then
    if is_valid_mac(ProcessingFlow[6].Destination.WWNN) then
        table.insert(addresses, ProcessingFlow[6].Destination.WWNN)
    end
    if is_valid_mac(ProcessingFlow[6].Destination.WWPN) then
        table.insert(addresses, ProcessingFlow[6].Destination.WWPN)
    end
    return addresses
end
if is_valid_mac(ProcessingFlow[2].Destination.MACAddress) then
    table.insert(addresses, ProcessingFlow[2].Destination.MACAddress)
end
return addresses
