-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local role_table = {
    NoAccess = 0,
    CommonUser = 2,
    Operator = 3,
    Administrator = 4,
    CustomRole1 = 5,
    CustomRole2 = 6,
    CustomRole3 = 7,
    CustomRole4 = 8,
    CustomRole5 = 9,
    CustomRole6 = 10,
    CustomRole7 = 11,
    CustomRole8 = 12,
    CustomRole9 = 13,
    CustomRole10 = 14,
    CustomRole11 = 15,
    CustomRole12 = 16,
    CustomRole13 = 17,
    CustomRole14 = 18,
    CustomRole15 = 19,
    CustomRole16 = 20
}

local role_id = {}

for _, group in ipairs(ReqBody.KerberosGroups) do
    table.insert(role_id, role_table[group.GroupRole])
end

return role_id