-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

local log = require 'mc.logging'
local utils = require 'mc.utils'

local METRIC_REPORT_DEF_PREFIX<const> = '/redfish/v1/TelemetryService/MetricReportDefinitions/'
local METRIC_REPORT_DEF_PATTERN<const> = '/redfish/v1/TelemetryService/MetricReportDefinitions/(.*)'
local METRIC_DEF_PATTERN<const> = '/redfish/v1/TelemetryService/MetricDefinitions/(.*)'
local TRIGGERS_INTF<const> = 'bmc.kepler.TelemetryService.Triggers'

-- @function 获取聚合过的Metric Report Values
-- @param    input  json_obj
-- @return   params table
function m.get_g_metric_report_values(input)
    local params = {}
    for i, v in ipairs(input) do
        params[i] = {}
        params[i]['MetricId'] = v['MetricId'] or ''
        params[i]['MetricValue'] = v['MetricValue'] or ''
        params[i]['Timestamp'] = v['Timestamp'] or ''
        params[i]['MetricProperty'] = v['MetricProperty'] or ''
        params[i]['MetricDefinition'] = v['MetricDefinition'] and v['MetricDefinition']['@odata.id'] or ''
        params[i]['MetricDefinition'] = string.match(params[i]['MetricDefinition'], METRIC_DEF_PATTERN) or ''
    end
    return params
end

-- @function 从MetricReportDefinitions获取MetricReportName
-- @param    input json_obj
-- @return   ids   table
function m.get_metric_report_names(input)
    if input == nil then
        return {}
    end
    local ids = {}
    local match
    for _, def in ipairs(input) do
        if not def['@odata.id'] then
            goto continue
        end
        match = string.match(def['@odata.id'], METRIC_REPORT_DEF_PATTERN) or nil
        if match then
            table.insert(ids, match)
        end
        ::continue::
    end
    return ids
end

-- @function 从MetricReportName拼接获取MetricReportDefinitions
-- @param    input json_obj
-- @return   ids   table
function m.get_metric_report_definitions(input)
    local ids = {}
    for i, def in ipairs(input) do 
        ids[i] = table.concat({METRIC_REPORT_DEF_PREFIX, def})
    end
    return ids
end

function m.match_linked_triggers(triggers_list, id)
    local ok, rsp
    local linked_triggers = {}
    for _, triggers in ipairs(triggers_list) do
        ok, rsp = pcall(mdb.get_object, bus, triggers, TRIGGERS_INTF)
        if not ok then
            log:info("Get Triggers object failed, err: %s.", rsp)
            goto continue
        end
        if utils.array_contains(rsp.MetricReportDefinitions, id) then
            table.insert(linked_triggers, triggers)
        end
        ::continue::
    end
    return linked_triggers
end

return m
