-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local file_utils = require 'utils.file'
local core_utils = require 'utils.core'
local m = {}

function m.get_installed_status(tasks, default_state)
    if not tasks then
        return default_state
    end
    for _, task in ipairs(tasks) do
        local obj = mdb.get_object(bus, task, 'bmc.kepler.TaskService.Task')
        if obj.State == 'Running' then
            return 'Installing'
        end
    end
    return default_state
end

local function is_valid_path(path)
    if not core_utils.is_file(path) then
        return false
    end

    if file_utils.check_real_path_s(path, "/tmp") ~= 0 then
        return false
    end
    return true
end

function m.is_import_permitted(type, content, role_id, is_permitted)
    if type ~= 'URI' then
        return true
    end

    if content:sub(1,1) ~= '/' then
        return true
    end

    if not is_valid_path(content) then
        error(custom_messages.IllegalContentBody())
    end
    if role_id == 4 or is_permitted then        -- 4 管理员RoleId
        return true
    end
    error(custom_messages.NoPrivilegeToOperateSpecifiedFile())
end

return m
