-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local utils = require 'mc.utils'
local m = {}

function m.get_members(slot, paths)
    if not paths then
        return {}
    end

    local uri_prefix = '/redfish/v1/Chassis/' .. slot .. '/Drives/'
    local members = {}
    for _, v in ipairs(paths) do
        local obj = mdb.get_object(bus, v, 'bmc.kepler.Systems.Storage.Drive')
        if obj ~= nil and obj.Presence == 1 then
            members[#members + 1] = {['@odata.id'] = uri_prefix .. obj.NodeId}
        end
    end

    return members
end

function m.get_volumes_link(volumes, ctr_id)
    if not volumes then
        return cjson.json_object_new_array()
    end

    if ctr_id == 255 then
        return cjson.json_object_new_array()
    end

    local link = {}
    for _, v in ipairs(volumes) do
        link[#link + 1] = {
            ['@odata.id'] = string.format(
                '/redfish/v1/Systems/1/Storages/RAIDStorage%d/Volumes/LogicalDrive%u',
                ctr_id,
                v
            )
        }
    end

    return link
end

function m.get_volume_id(volumepath)
    local list = utils.split(volumepath, '/')
    local id = string.match(list[#list], 'LogicalDrive(%d+)')
    return id
end

return m
