-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local vos = require 'utils.vos'
local utils = require 'mc.utils'
local utils_core = require 'utils.core'
local cjson = require 'cjson'

local m = {}

local VIDEO_PATH = {
    '/data/share/video/video_caterror.rep',
    '/tmp/poweroff/video_poweroff.rep',
    '/tmp/osreset/video_osreset.rep'
}

local SCREENSHOT_PATH = {
    '/data/share/img/img1.jpeg',
    '/data/share/img/img2.jpeg',
    '/data/share/img/img3.jpeg',
    '/data/share/img/manualscreen.jpeg'
}

local function get_file_attribute(file_path)
    local file_size = 0
    local create_time = cjson.null

    if vos.get_file_accessible(file_path) then
        local file_stat = utils_core.stat(file_path)
        file_size = file_stat.st_size
        create_time = utils.date_format(file_stat.st_mtim.tv_sec, "%Y-%m-%d %H:%M:%S", false)
    end
    return {file_size = file_size, create_time = create_time}
end

function m.get_video_attributes()
    local attributes = cjson.json_object_new_array()
    for i = 1, #VIDEO_PATH do
        local temp_attr = get_file_attribute(VIDEO_PATH[i])
        if temp_attr.file_size == 0 then
            attributes[#attributes + 1] = cjson.null
        else
            local video_attribute = cjson.json_object_new_object()
            video_attribute.VideoSizeByte = temp_attr.file_size
            video_attribute.CreateTime = temp_attr.create_time
            attributes[#attributes + 1] = video_attribute
        end
    end
    return attributes
end

function m.get_screenshot_createtime()
    local attributes = cjson.json_object_new_array()
    for i = 1, #SCREENSHOT_PATH do
        attributes[#attributes + 1] = get_file_attribute(SCREENSHOT_PATH[i]).create_time
    end
    return attributes
end

return m
