-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local interfaces_t = {
    [1] = 'Web',
    [2] = 'SNMP',
    [3] = 'IPMI',
    [4] = 'SSH',
    [5] = 'SFTP',
    [7] = 'Local',
    [8] = 'Redfish'
}

local set_intfs = {
    interfaces_t[ReqBody.option1],
    interfaces_t[ReqBody.option2],
    interfaces_t[ReqBody.option3],
    interfaces_t[ReqBody.option4],
    interfaces_t[ReqBody.option5],
    interfaces_t[ReqBody.option6],
    interfaces_t[ReqBody.option7]
}

local real_set_intfs = {}
local intfs_set_table = {}
local original_intfs_table = {}

local intfs = ProcessingFlow[2].Destination.LoginInterface
local len = #intfs

local is_need_reset_pwd = false
local path = ProcessingFlow[1].Destination.Path
if type(path) == 'string' and #path > 0 then
    local idx = 1
    for _, v in pairs(set_intfs) do
        if v then
            intfs_set_table[v] = true
            real_set_intfs[idx] = v
            idx = idx + 1
        end
    end

    for _, v in ipairs(intfs) do
        if v then
            original_intfs_table[v] = true
        end
    end

    if ReqBody.enabled == 'enabled' then
        for _, v in ipairs(real_set_intfs) do
            if not original_intfs_table[v] then
                if v == 'IPMI' or v == 'SNMP' then
                    is_need_reset_pwd = true
                end
                table.insert(intfs, v)
            end
        end
    else
        for i = len, 1, -1 do
            if intfs_set_table[intfs[i]] then
                table.remove(intfs, i)
            end
        end
    end
end

return {is_need_reset_pwd, intfs}