-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local IPMC_VNC_PASSWORD_LEN<const> = 8

local m = {}

function m.get_pwd()
    local status, password = libroutemapper_utils.get_line_without_echo('New VNC Password:')
    if status ~= 0 then
        return {-1, password}
    end

    local password_confirm
    status, password_confirm = libroutemapper_utils.get_line_without_echo('Confirm VNC Password:')
    if status ~= 0 or password ~= password_confirm then
        return {-2, password}
    end

    if status ~= 0 or #password > IPMC_VNC_PASSWORD_LEN then
        return {-3, password}
    end

    local res = {}
    for i = 1, #password do
        res[i] = password:byte(i)
    end

    return {0, res}
end

return m
