-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils_core = require 'utils.core'
local MAX_FILEPATH_LENGTH <const> = 256
local PREFIX<const> = '/tmp'

local m = {}

-- 升级命令文件路径的合法校验
function m.get_update_filepath(upgrade_file)
    local file_len = string.len(upgrade_file)
    if file_len > MAX_FILEPATH_LENGTH -1 or string.sub(upgrade_file, 1, 1) ~= '/' then
        return {false}
    end
    local real_path =  utils_core.realpath(upgrade_file)
    if not real_path then
        return {false}
    end
    if file_len < 4 or string.sub(real_path, 1, 4) ~= PREFIX or string.sub(upgrade_file, 1, 4) ~= PREFIX then
        return {false}
    end
    return {true, real_path}
end

function m.get_expand_parameters(active_mode)
    local ret_paras = {}
    local active_mode_tab = {
        [0] = 'ResetBMC',
        [1] = 'Immediately'
    }
    if active_mode and type(active_mode) == "number" then
        ret_paras.ActiveMode = active_mode_tab[active_mode]
    end
    if not active_mode then
        ret_paras.ActiveMode = "Immediately"
    end
    return ret_paras
end

return m
