-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local utils = require 'mc.utils'
local cjson = require 'cjson'
local mdb_service = require 'mc.mdb.mdb_service'

local CONTROLLER_INTERFACE = 'bmc.kepler.Systems.Storage.Controller'

-- GetPath函数返回的无效路径
local INVALID_PATH<const> = ''

local m = {}

function m.split_str(str, delimiter)
    local list = utils.split(str, delimiter)
    log:error(list)
    return list
end

local function get_controller_obj_by_id(controller_id)
    local filter = {Id = controller_id}
    local ok, rsp = pcall(mdb_service.get_path, bus, CONTROLLER_INTERFACE, cjson.encode(filter), false)
    if not ok then
        log:info('Verify controller id(%s) failed, err(%s)', controller_id, rsp.message)
        return
    end

    if rsp.Path == INVALID_PATH then
        log:info('Get invalid path of controller(%s)', controller_id)
        return
    end

    local controller_obj
    ok, controller_obj = pcall(function ()
        return mdb.get_object(bus, rsp.Path, CONTROLLER_INTERFACE)
    end)
    if not ok then
        log:info('Get controller object failed, ret = %s', controller_obj)
        return
    end
    return controller_obj
end

function m.get_ctrl_typeid(ref_controller_id)
    local controller_obj = get_controller_obj_by_id(ref_controller_id)
    local type_id = controller_obj and controller_obj.TypeId
    if type_id then
        return type_id
    end
    return 0xff
end
return m
