-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local file_utils = require 'utils.file'
local core_utils = require 'utils.core'
local m = {}
function m.is_crlimport_permitted(content)
    if content:sub(1,1) ~= '/' then
        return true
    end
    if not core_utils.is_file(content) then
        return false
    end
    if file_utils.check_real_path_s(content, "/tmp") ~= 0 then
        return false
    end
    return true
end

return m