# board_info_collector
## 一、映射器介绍
1、支持装备测试正向采集特性，需要在product_mgmt实现一个映射器，用以查询各类信息。
2、而当前目录则是存放相关的映射器配置

## 二、目录介绍
```
.
└── interface_config                        # 北向接口
    ├── board_info_collector                # 支持正向采集映射器配置
    │   ├── config                          # 配置目录
    │       ├── BoardInfo.json              # 正向采集uri配置                   （伙伴需要修改）
    │       ├── SPDeviceInfo.json           # 查询sp的deviceinfo.json在位的uri，（伙伴可以不关注）
    │   ├── plugins                         # 插件目录
    │       ├── BoardInfo.json              # 正向采集插件                      （伙伴可以添加接口）
    │
    ├── cli                             # redfish接口映射配置
    ├── redfish                             # redfish接口映射配置
    ├── snmp                                # snmp接口映射配置
    └── web_backend                         # web_backend接口映射配置
```

## 三、开发约定
1、board_info_collector目录下的目录结构不要随意改动
2、rackmount仓的构建裁剪脚本conanfile.py会把board_info_collector目录放到/opt/bmc/board_info_collector
3、BoardInfo.json 里面的uri也是跟product_mgmt组件的业务绑定，"Uri": "/collect/BoardInfo" 不要修改。
4、除了Uri绑定以外，其他需要采集的信息，均可以按照定制需求实现。