-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local skynet = require 'skynet'
local log = require 'mc.logging'
local context = require 'mc.context'

local cases = {}

local function test_service_exist(bus)
    log:info('==> test rack mgmt service exist start ...')

    local name = 'bmc.kepler.rack_mgmt'
    local path = '/bmc/kepler/rack_mgmt/MicroComponent'
    local intf = 'bmc.kepler.Object.Properties'
    local prop_intf = 'bmc.kepler.MicroComponent'
    local ctx = context.get_context_or_default()
    local err, rsp

    -- 在服务上线后，尝试获取5次组件名，如果出现5次都获取不到，说明组件初始化过程是有问题的
    for i = 1, 5 do
        err, rsp = bus:timeout_pcall(3000, name, path, intf, 'GetWithContext', 'a{ss}ss', ctx, prop_intf, 'Name')
        if not err then
            break
        end

        if i < 5 then
            skynet.sleep(200)
        end
    end
    assert(rsp)
    assert(rsp:value() == '', 'actual: ' .. rsp:value())

    log:info('==> test rack mgmt service exist completed ...')
end

function cases.test_entry(bus)
    log:info('==> test rack mgmt service cases start ...')

    test_service_exist(bus)

    log:info('==> test rack mgmt service cases completed ...')
end

return cases