-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local service = require 'rack_service'

local app = nil
local app_cmd = {}

function app_cmd.exit()
    skynet.timeout(0, function()
        log:notice('[rack_mgmt] service prepare to exit')
        app:exit()
        skynet.exit()
    end)
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('.rack_mgmt')

    -- 启动主服务
    local ok, ret = pcall(service.new)
    if not ok then
        log:error('[rack_mgmt] service start failed, err: %s', ret)
        return
    end

    app = ret
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(app_cmd[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)

    skynet.newservice("debug_console", '0.0.0.0', 40044)
end)
