-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Rack 管理服务主程
local log = require 'mc.logging'
local class = require 'mc.class'
local mc_admin = require 'mc.mc_admin'
local orm_object_manage = require 'mc.orm.object_manage'
local base_service = require 'rack_mgmt.service'

local rack_service = class(base_service)

-- 依赖检查
local function check_dependencies(bus)
    local admin = mc_admin.new()
    admin:parse_dependency(APP_WORKING_DIRECTORY .. '/mds/service.json')
    admin:check_dependency(bus)
end

-- 启动orm管理
function rack_service:start_orm_management()
    self.orm = orm_object_manage.new(self.db, self.bus)
    self.orm:start()
end

function rack_service:init()
    log:notice('[rack mgmt] service init start ...')
    rack_service.super.init(self)
    check_dependencies(self.bus)
    self:start_orm_management()
    log:notice('[rack mgmt] service init completed ...')
end

function rack_service:exit()
    log:notice('[rack mgmt] has no extra action to exit.')
end

return rack_service