-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Rack 产品配置数据
local config = {}

config.LLDP_INFO = {
    BASE = '/bmc/kepler/Managers',
    PATH = '/bmc/kepler/Managers/1/LLDPInfo',
    INTF = 'bmc.kepler.Managers.LLDPInfo'
}

config.NODE_LOC = {
    PATH = '/bmc/kepler/Managers/1/NodeLocation',
    INTF = 'bmc.kepler.Managers.NodeLocation'
}

config.SWITCH_DESC = {
    ['HUAWEI DX111'] = 'HUAWEI_DX111',
    ['8850-64CQ-EI'] = 'HUAWEI_8850_64CQ',
    ['DX511'] = 'DX511',
    ['CE9860-4C-EI'] = 'CE9860_4C',
    ['DX112'] = 'DX112'
}

config.SWITCH_ORG = {
    ['8850-64CQ-EI'] = {
        ['[LinkMapId:1]'] = 'HUAWEI_8850_64CQ_ORG'
    }
}

config.SWITCH_PREFIX = {
    "100GE1",
    "100GE2",
    "100GE3",
    "100GE4",
    "25GE1",
    "400GE1"
}

config.SWITCH_SUFFIX = {
    HUAWEI_DX111 = {
        {Suffix = "/1/1:1", Slot = 26},
        {Suffix = "/1/1:2", Slot = 26},
        {Suffix = "/1/1:3", Slot = 25},
        {Suffix = "/1/1:4", Slot = 25},
        {Suffix = "/2/1:1", Slot = 30},
        {Suffix = "/2/1:2", Slot = 30},
        {Suffix = "/2/1:3", Slot = 29},
        {Suffix = "/2/1:4", Slot = 29},
        {Suffix = "/3/1:1", Slot = 34},
        {Suffix = "/3/1:2", Slot = 34},
        {Suffix = "/3/1:3", Slot = 33},
        {Suffix = "/3/1:4", Slot = 33},
        {Suffix = "/4/1:1", Slot = 4},
        {Suffix = "/4/1:2", Slot = 4},
        {Suffix = "/4/1:3", Slot = 3},
        {Suffix = "/4/1:4", Slot = 3},
        {Suffix = "/5/1:1", Slot = 8},
        {Suffix = "/5/1:2", Slot = 8},
        {Suffix = "/5/1:3", Slot = 7},
        {Suffix = "/5/1:4", Slot = 7},
        {Suffix = "/6/1:1", Slot = 12},
        {Suffix = "/6/1:2", Slot = 12},
        {Suffix = "/6/1:3", Slot = 11},
        {Suffix = "/6/1:4", Slot = 11},
        {Suffix = "/7/1:1", Slot = 14},
        {Suffix = "/7/1:2", Slot = 14},
        {Suffix = "/7/1:3", Slot = 13},
        {Suffix = "/7/1:4", Slot = 13},
        {Suffix = "/8/1:1", Slot = 17},
        {Suffix = "/8/1:2", Slot = 17},
        {Suffix = "/8/1:3", Slot = 18},
        {Suffix = "/8/1:4", Slot = 18},
        {Suffix = "/9/1:1", Slot = 24},
        {Suffix = "/9/1:2", Slot = 24},
        {Suffix = "/9/1:3", Slot = 23},
        {Suffix = "/9/1:4", Slot = 23},
        {Suffix = "/10/1:1", Slot = 28},
        {Suffix = "/10/1:2", Slot = 28},
        {Suffix = "/10/1:3", Slot = 27},
        {Suffix = "/10/1:4", Slot = 27},
        {Suffix = "/11/1:1", Slot = 32},
        {Suffix = "/11/1:2", Slot = 32},
        {Suffix = "/11/1:3", Slot = 31},
        {Suffix = "/11/1:4", Slot = 31},
        {Suffix = "/12/1:1", Slot = 2},
        {Suffix = "/12/1:2", Slot = 2},
        {Suffix = "/12/1:3", Slot = 1},
        {Suffix = "/12/1:4", Slot = 1},
        {Suffix = "/13/1:1", Slot = 6},
        {Suffix = "/13/1:2", Slot = 6},
        {Suffix = "/13/1:3", Slot = 5},
        {Suffix = "/13/1:4", Slot = 5},
        {Suffix = "/14/1:1", Slot = 10},
        {Suffix = "/14/1:2", Slot = 10},
        {Suffix = "/14/1:3", Slot = 9},
        {Suffix = "/14/1:4", Slot = 9},
        {Suffix = "/15/1:1", Slot = 16},
        {Suffix = "/15/1:2", Slot = 16},
        {Suffix = "/15/1:3", Slot = 15},
        {Suffix = "/15/1:4", Slot = 15},
        {Suffix = "/16/1:1", Slot = 19},
        {Suffix = "/16/1:2", Slot = 19},
        {Suffix = "/16/1:3", Slot = 20},
        {Suffix = "/16/1:4", Slot = 20},
        {Suffix = "/18/1:1", Slot = 38},
        {Suffix = "/18/1:2", Slot = 38},
        {Suffix = "/18/1:3", Slot = 37},
        {Suffix = "/18/1:4", Slot = 37},
        {Suffix = "/18/2:1", Slot = 36},
        {Suffix = "/18/2:2", Slot = 36},
        {Suffix = "/18/2:3", Slot = 35},
        {Suffix = "/18/2:4", Slot = 35}
    },
    HUAWEI_8850_64CQ = {
        {Suffix = "/0/5:1", Slot = 15},
        {Suffix = "/0/5:2", Slot = 16},
        {Suffix = "/0/5:3", Slot = 17},
        {Suffix = "/0/5:4", Slot = 18},
        {Suffix = "/0/6:1", Slot = 15},
        {Suffix = "/0/6:2", Slot = 16},
        {Suffix = "/0/6:3", Slot = 17},
        {Suffix = "/0/6:4", Slot = 18},
        {Suffix = "/0/7:1", Slot = 15},
        {Suffix = "/0/7:2", Slot = 16},
        {Suffix = "/0/7:3", Slot = 17},
        {Suffix = "/0/7:4", Slot = 18},
        {Suffix = "/0/9:1", Slot = 11},
        {Suffix = "/0/9:2", Slot = 12},
        {Suffix = "/0/9:3", Slot = 13},
        {Suffix = "/0/9:4", Slot = 14},
        {Suffix = "/0/10:1", Slot = 11},
        {Suffix = "/0/10:2", Slot = 12},
        {Suffix = "/0/10:3", Slot = 13},
        {Suffix = "/0/10:4", Slot = 14},
        {Suffix = "/0/11:1", Slot = 11},
        {Suffix = "/0/11:2", Slot = 12},
        {Suffix = "/0/11:3", Slot = 13},
        {Suffix = "/0/11:4", Slot = 14},
        {Suffix = "/0/21:1", Slot = 7},
        {Suffix = "/0/21:2", Slot = 8},
        {Suffix = "/0/21:3", Slot = 9},
        {Suffix = "/0/21:4", Slot = 10},
        {Suffix = "/0/22:1", Slot = 7},
        {Suffix = "/0/22:2", Slot = 8},
        {Suffix = "/0/22:3", Slot = 9},
        {Suffix = "/0/22:4", Slot = 10},
        {Suffix = "/0/23:1", Slot = 7},
        {Suffix = "/0/23:2", Slot = 8},
        {Suffix = "/0/23:3", Slot = 9},
        {Suffix = "/0/23:4", Slot = 10},
        {Suffix = "/0/25:1", Slot = 3},
        {Suffix = "/0/25:2", Slot = 4},
        {Suffix = "/0/25:3", Slot = 5},
        {Suffix = "/0/25:4", Slot = 6},
        {Suffix = "/0/26:1", Slot = 3},
        {Suffix = "/0/26:2", Slot = 4},
        {Suffix = "/0/26:3", Slot = 5},
        {Suffix = "/0/26:4", Slot = 6},
        {Suffix = "/0/27:1", Slot = 3},
        {Suffix = "/0/27:2", Slot = 4},
        {Suffix = "/0/27:3", Slot = 5},
        {Suffix = "/0/27:4", Slot = 6},
        {Suffix = "/0/37:1", Slot = 37},
        {Suffix = "/0/37:2", Slot = 38},
        {Suffix = "/0/37:3", Slot = 1},
        {Suffix = "/0/37:4", Slot = 2},
        {Suffix = "/0/38:1", Slot = 37},
        {Suffix = "/0/38:2", Slot = 38},
        {Suffix = "/0/38:3", Slot = 1},
        {Suffix = "/0/38:4", Slot = 2},
        {Suffix = "/0/39:1", Slot = 37},
        {Suffix = "/0/39:2", Slot = 38},
        {Suffix = "/0/39:3", Slot = 1},
        {Suffix = "/0/39:4", Slot = 2},
        {Suffix = "/0/41:1", Slot = 33},
        {Suffix = "/0/41:2", Slot = 34},
        {Suffix = "/0/41:3", Slot = 35},
        {Suffix = "/0/41:4", Slot = 36},
        {Suffix = "/0/42:1", Slot = 33},
        {Suffix = "/0/42:2", Slot = 34},
        {Suffix = "/0/42:3", Slot = 35},
        {Suffix = "/0/42:4", Slot = 36},
        {Suffix = "/0/43:1", Slot = 33},
        {Suffix = "/0/43:2", Slot = 34},
        {Suffix = "/0/43:3", Slot = 35},
        {Suffix = "/0/43:4", Slot = 36},
        {Suffix = "/0/53:1", Slot = 29},
        {Suffix = "/0/53:2", Slot = 30},
        {Suffix = "/0/53:3", Slot = 31},
        {Suffix = "/0/53:4", Slot = 32},
        {Suffix = "/0/54:1", Slot = 29},
        {Suffix = "/0/54:2", Slot = 30},
        {Suffix = "/0/54:3", Slot = 31},
        {Suffix = "/0/54:4", Slot = 32},
        {Suffix = "/0/55:1", Slot = 29},
        {Suffix = "/0/55:2", Slot = 30},
        {Suffix = "/0/55:3", Slot = 31},
        {Suffix = "/0/55:4", Slot = 32},
        {Suffix = "/0/57:1", Slot = 25},
        {Suffix = "/0/57:2", Slot = 26},
        {Suffix = "/0/57:3", Slot = 27},
        {Suffix = "/0/57:4", Slot = 28},
        {Suffix = "/0/58:1", Slot = 25},
        {Suffix = "/0/58:2", Slot = 26},
        {Suffix = "/0/58:3", Slot = 27},
        {Suffix = "/0/58:4", Slot = 28},
        {Suffix = "/0/59:1", Slot = 25},
        {Suffix = "/0/59:2", Slot = 26},
        {Suffix = "/0/59:3", Slot = 27},
        {Suffix = "/0/59:4", Slot = 28}
    },
    HUAWEI_8850_64CQ_ORG = {
        {Suffix = "/0/10:4", Slot = 18},
        {Suffix = "/0/10:3", Slot = 17},
        {Suffix = "/0/10:2", Slot = 16},
        {Suffix = "/0/10:1", Slot = 15},
        {Suffix = "/0/14:4", Slot = 14},
        {Suffix = "/0/14:3", Slot = 13},
        {Suffix = "/0/14:2", Slot = 12},
        {Suffix = "/0/14:1", Slot = 11},
        {Suffix = "/0/26:4", Slot = 10},
        {Suffix = "/0/26:3", Slot = 9},
        {Suffix = "/0/26:2", Slot = 8},
        {Suffix = "/0/26:1", Slot = 7},
        {Suffix = "/0/30:4", Slot = 6},
        {Suffix = "/0/30:3", Slot = 5},
        {Suffix = "/0/30:2", Slot = 4},
        {Suffix = "/0/30:1", Slot = 3},
        {Suffix = "/0/42:4", Slot = 2},
        {Suffix = "/0/42:3", Slot = 1},
        {Suffix = "/0/42:2", Slot = 38},
        {Suffix = "/0/42:1", Slot = 37},
        {Suffix = "/0/46:4", Slot = 36},
        {Suffix = "/0/46:3", Slot = 35},
        {Suffix = "/0/46:2", Slot = 34},
        {Suffix = "/0/46:1", Slot = 33},
        {Suffix = "/0/58:4", Slot = 32},
        {Suffix = "/0/58:3", Slot = 31},
        {Suffix = "/0/58:2", Slot = 30},
        {Suffix = "/0/58:1", Slot = 29},
        {Suffix = "/0/62:4", Slot = 28},
        {Suffix = "/0/62:3", Slot = 27},
        {Suffix = "/0/62:2", Slot = 26},
        {Suffix = "/0/62:1", Slot = 25}
    },
    DX511 = {
        {Suffix = "/1/41", Slot = 17},
        {Suffix = "/1/42", Slot = 17},
        {Suffix = "/1/43", Slot = 18},
        {Suffix = "/1/44", Slot = 18},
        {Suffix = "/1/45", Slot = 19},
        {Suffix = "/1/46", Slot = 19},
        {Suffix = "/1/47", Slot = 20},
        {Suffix = "/1/48", Slot = 20},
        {Suffix = "/1/57", Slot = 29},
        {Suffix = "/1/58", Slot = 29},
        {Suffix = "/1/59", Slot = 30},
        {Suffix = "/1/60", Slot = 30},
        {Suffix = "/1/61", Slot = 31},
        {Suffix = "/1/62", Slot = 31},
        {Suffix = "/1/63", Slot = 32},
        {Suffix = "/1/64", Slot = 32},
        {Suffix = "/1/25", Slot = 9},
        {Suffix = "/1/26", Slot = 9},
        {Suffix = "/1/27", Slot = 10},
        {Suffix = "/1/28", Slot = 10},
        {Suffix = "/1/29", Slot = 11},
        {Suffix = "/1/30", Slot = 11},
        {Suffix = "/1/31", Slot = 12},
        {Suffix = "/1/32", Slot = 12},
        {Suffix = "/1/73", Slot = 37},
        {Suffix = "/1/74", Slot = 37},
        {Suffix = "/1/75", Slot = 38},
        {Suffix = "/1/76", Slot = 38},
        {Suffix = "/1/77", Slot = 39},
        {Suffix = "/1/78", Slot = 39},
        {Suffix = "/1/79", Slot = 40},
        {Suffix = "/1/80", Slot = 40},
        {Suffix = "/1/17", Slot = 5},
        {Suffix = "/1/18", Slot = 5},
        {Suffix = "/1/19", Slot = 6},
        {Suffix = "/1/20", Slot = 6},
        {Suffix = "/1/21", Slot = 7},
        {Suffix = "/1/22", Slot = 7},
        {Suffix = "/1/23", Slot = 8},
        {Suffix = "/1/24", Slot = 8},
        {Suffix = "/1/65", Slot = 33},
        {Suffix = "/1/66", Slot = 33},
        {Suffix = "/1/67", Slot = 34},
        {Suffix = "/1/68", Slot = 34},
        {Suffix = "/1/69", Slot = 35},
        {Suffix = "/1/70", Slot = 35},
        {Suffix = "/1/71", Slot = 36},
        {Suffix = "/1/72", Slot = 36},
        {Suffix = "/1/33", Slot = 13},
        {Suffix = "/1/34", Slot = 13},
        {Suffix = "/1/35", Slot = 14},
        {Suffix = "/1/36", Slot = 14},
        {Suffix = "/1/37", Slot = 15},
        {Suffix = "/1/38", Slot = 15},
        {Suffix = "/1/39", Slot = 16},
        {Suffix = "/1/40", Slot = 16},
        {Suffix = "/1/49", Slot = 25},
        {Suffix = "/1/50", Slot = 25},
        {Suffix = "/1/51", Slot = 26},
        {Suffix = "/1/52", Slot = 26},
        {Suffix = "/1/53", Slot = 27},
        {Suffix = "/1/54", Slot = 27},
        {Suffix = "/1/55", Slot = 28},
        {Suffix = "/1/56", Slot = 28},
        {Suffix = "/1/18:2", Slot = 8},
        {Suffix = "/1/20:2", Slot = 12},
        {Suffix = "/1/22:2", Slot = 16},
        {Suffix = "/1/24:2", Slot = 20},
        {Suffix = "/1/26:2", Slot = 28},
        {Suffix = "/1/28:2", Slot = 32},
        {Suffix = "/1/30:2", Slot = 36},
        {Suffix = "/1/32:2", Slot = 40},
    },
    CE9860_4C = {
        {Suffix = "/1/41", Slot = 17},
        {Suffix = "/1/42", Slot = 17},
        {Suffix = "/1/43", Slot = 18},
        {Suffix = "/1/44", Slot = 18},
        {Suffix = "/1/45", Slot = 19},
        {Suffix = "/1/46", Slot = 19},
        {Suffix = "/1/47", Slot = 20},
        {Suffix = "/1/48", Slot = 20},
        {Suffix = "/1/57", Slot = 29},
        {Suffix = "/1/58", Slot = 29},
        {Suffix = "/1/59", Slot = 30},
        {Suffix = "/1/60", Slot = 30},
        {Suffix = "/1/61", Slot = 31},
        {Suffix = "/1/62", Slot = 31},
        {Suffix = "/1/63", Slot = 32},
        {Suffix = "/1/64", Slot = 32},
        {Suffix = "/1/25", Slot = 9},
        {Suffix = "/1/26", Slot = 9},
        {Suffix = "/1/27", Slot = 10},
        {Suffix = "/1/28", Slot = 10},
        {Suffix = "/1/29", Slot = 11},
        {Suffix = "/1/30", Slot = 11},
        {Suffix = "/1/31", Slot = 12},
        {Suffix = "/1/32", Slot = 12},
        {Suffix = "/1/73", Slot = 37},
        {Suffix = "/1/74", Slot = 37},
        {Suffix = "/1/75", Slot = 38},
        {Suffix = "/1/76", Slot = 38},
        {Suffix = "/1/77", Slot = 39},
        {Suffix = "/1/78", Slot = 39},
        {Suffix = "/1/79", Slot = 40},
        {Suffix = "/1/80", Slot = 40},
        {Suffix = "/1/17", Slot = 5},
        {Suffix = "/1/18", Slot = 5},
        {Suffix = "/1/19", Slot = 6},
        {Suffix = "/1/20", Slot = 6},
        {Suffix = "/1/21", Slot = 7},
        {Suffix = "/1/22", Slot = 7},
        {Suffix = "/1/23", Slot = 8},
        {Suffix = "/1/24", Slot = 8},
        {Suffix = "/1/65", Slot = 33},
        {Suffix = "/1/66", Slot = 33},
        {Suffix = "/1/67", Slot = 34},
        {Suffix = "/1/68", Slot = 34},
        {Suffix = "/1/69", Slot = 35},
        {Suffix = "/1/70", Slot = 35},
        {Suffix = "/1/71", Slot = 36},
        {Suffix = "/1/72", Slot = 36},
        {Suffix = "/1/33", Slot = 13},
        {Suffix = "/1/34", Slot = 13},
        {Suffix = "/1/35", Slot = 14},
        {Suffix = "/1/36", Slot = 14},
        {Suffix = "/1/37", Slot = 15},
        {Suffix = "/1/38", Slot = 15},
        {Suffix = "/1/39", Slot = 16},
        {Suffix = "/1/40", Slot = 16},
        {Suffix = "/1/49", Slot = 25},
        {Suffix = "/1/50", Slot = 25},
        {Suffix = "/1/51", Slot = 26},
        {Suffix = "/1/52", Slot = 26},
        {Suffix = "/1/53", Slot = 27},
        {Suffix = "/1/54", Slot = 27},
        {Suffix = "/1/55", Slot = 28},
        {Suffix = "/1/56", Slot = 28},
        {Suffix = "/1/18:2", Slot = 8},
        {Suffix = "/1/20:2", Slot = 12},
        {Suffix = "/1/22:2", Slot = 16},
        {Suffix = "/1/24:2", Slot = 20},
        {Suffix = "/1/26:2", Slot = 28},
        {Suffix = "/1/28:2", Slot = 32},
        {Suffix = "/1/30:2", Slot = 36},
        {Suffix = "/1/32:2", Slot = 40},
    },
    DX112 = {
        {Suffix = "/0/40", Slot = 20},
        {Suffix = "/0/39", Slot = 20},
        {Suffix = "/0/38", Slot = 19},
        {Suffix = "/0/37", Slot = 19},
        {Suffix = "/0/36", Slot = 18},
        {Suffix = "/0/35", Slot = 18},
        {Suffix = "/0/34", Slot = 17},
        {Suffix = "/0/33", Slot = 17},
        {Suffix = "/0/56", Slot = 32},
        {Suffix = "/0/55", Slot = 32},
        {Suffix = "/0/54", Slot = 31},
        {Suffix = "/0/53", Slot = 31},
        {Suffix = "/0/52", Slot = 30},
        {Suffix = "/0/51", Slot = 30},
        {Suffix = "/0/50", Slot = 29},
        {Suffix = "/0/49", Slot = 29},
        {Suffix = "/0/24", Slot = 12},
        {Suffix = "/0/23", Slot = 12},
        {Suffix = "/0/22", Slot = 11},
        {Suffix = "/0/21", Slot = 11},
        {Suffix = "/0/20", Slot = 10},
        {Suffix = "/0/19", Slot = 10},
        {Suffix = "/0/18", Slot = 9},
        {Suffix = "/0/17", Slot = 9},
        {Suffix = "/0/72", Slot = 40},
        {Suffix = "/0/71", Slot = 40},
        {Suffix = "/0/70", Slot = 39},
        {Suffix = "/0/69", Slot = 39},
        {Suffix = "/0/68", Slot = 38},
        {Suffix = "/0/67", Slot = 38},
        {Suffix = "/0/66", Slot = 37},
        {Suffix = "/0/65", Slot = 37},
        {Suffix = "/0/8", Slot = 4},
        {Suffix = "/0/7", Slot = 4},
        {Suffix = "/0/6", Slot = 3},
        {Suffix = "/0/5", Slot = 3},
        {Suffix = "/0/4", Slot = 2},
        {Suffix = "/0/3", Slot = 2},
        {Suffix = "/0/2", Slot = 1},
        {Suffix = "/0/1", Slot = 1},
        {Suffix = "/0/16", Slot = 8},
        {Suffix = "/0/15", Slot = 8},
        {Suffix = "/0/14", Slot = 7},
        {Suffix = "/0/13", Slot = 7},
        {Suffix = "/0/12", Slot = 6},
        {Suffix = "/0/11", Slot = 6},
        {Suffix = "/0/10", Slot = 5},
        {Suffix = "/0/9", Slot = 5},
        {Suffix = "/0/64", Slot = 36},
        {Suffix = "/0/63", Slot = 36},
        {Suffix = "/0/62", Slot = 35},
        {Suffix = "/0/61", Slot = 35},
        {Suffix = "/0/60", Slot = 34},
        {Suffix = "/0/59", Slot = 34},
        {Suffix = "/0/58", Slot = 33},
        {Suffix = "/0/57", Slot = 33},
        {Suffix = "/0/32", Slot = 16},
        {Suffix = "/0/31", Slot = 16},
        {Suffix = "/0/30", Slot = 15},
        {Suffix = "/0/29", Slot = 15},
        {Suffix = "/0/28", Slot = 14},
        {Suffix = "/0/27", Slot = 14},
        {Suffix = "/0/26", Slot = 13},
        {Suffix = "/0/25", Slot = 13},
        {Suffix = "/0/48", Slot = 28},
        {Suffix = "/0/47", Slot = 28},
        {Suffix = "/0/46", Slot = 27},
        {Suffix = "/0/45", Slot = 27},
        {Suffix = "/0/44", Slot = 26},
        {Suffix = "/0/43", Slot = 26},
        {Suffix = "/0/42", Slot = 25},
        {Suffix = "/0/41", Slot = 25},
    }
}

return config