-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local open_db = require 'rack_mgmt.db'
local app_base = require 'mc.service_app_base'
local class = require 'mc.class'
local mdb = require 'mc.mdb'
local context = require 'mc.context'

local HeartBeatTypes = require 'rack_mgmt.json_types.HeartBeat'
local PropertiesTypes = require 'rack_mgmt.json_types.Properties'

local HeartBeat = mdb.register_object('/bmc/kepler/Managers/:ManagerId/HeartBeat/:Id', {
    {name = 'bmc.kepler.Managers.HeartBeat', interface = HeartBeatTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function HeartBeat:ctor(ManagerId, Id)
    self.path = '/bmc/kepler/Managers/' .. ManagerId .. '/HeartBeat/' .. Id .. ''
end

local cls_mng = require 'mc.class_mgnt'
local model = require 'class.model'

local open_db = require 'rack_mgmt.db'
local orm_classes = require 'rack_mgmt.orm_classes'
local ok, datas = pcall(require, 'rack_mgmt.datas')
if not ok then
    -- 如果没有datas配置，证明当前组件不需要datas，仅打开数据库
    datas = nil
end

local rack_mgmt_service = class(app_base.Service)

rack_mgmt_service.subscriptions = {}
function rack_mgmt_service:SubscribeAll()
    if self.has_subscribe_all then
        return
    end

    for i = 1, #self.subscriptions do
        self.subscriptions[i](self)
    end

    self.has_subscribe_all = true
end

rack_mgmt_service.package = 'rack_mgmt'

function rack_mgmt_service:CreateHeartBeat(ManagerId, Id, prop_setting_cb)
    local path = '/bmc/kepler/Managers/' .. ManagerId .. '/HeartBeat/' .. Id .. ''
    local object = cls_mng('HeartBeat').new(path)
    object:create_mdb_objects(path)
    if prop_setting_cb then
        prop_setting_cb(object)
    end
    object:register_mdb_objects()
    return object
end

function rack_mgmt_service:ImplHeartBeatHeartBeatBeat(cb)
    model.ImplHeartBeatHeartBeatBeat(cb)
end

function rack_mgmt_service:get_bus()
    return self.bus
end

function rack_mgmt_service:ctor()
    if not self.name then
        self.name = rack_mgmt_service.package
    end
    self.signal_slots = {}
    self.db = open_db(':memory:', datas)
    orm_classes.init(self.db)
    self.bus:request_name(app_base.Service.get_service_name(self.name))

    model.init(self.bus)

    rack_mgmt_service.bus = self.bus
end

function rack_mgmt_service:pre_init()
    if rack_mgmt_service.super.pre_init then
    rack_mgmt_service.super.pre_init(self)
    end
end

function rack_mgmt_service:init()
    rack_mgmt_service.super.init(self)
    self:SubscribeAll()

end

return rack_mgmt_service
