-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local HeartBeat = {}

---@class HeartBeat.Status
---@field Status string
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj HeartBeat.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {''}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

HeartBeat.Status = TStatus

---@class HeartBeat.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj HeartBeat.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

HeartBeat.Name = TName

---@class HeartBeat.BeatRsp
local TBeatRsp = {}
TBeatRsp.__index = TBeatRsp
TBeatRsp.group = {}

local function TBeatRsp_from_obj(obj)
    return setmetatable(obj, TBeatRsp)
end

function TBeatRsp.new()
    return TBeatRsp_from_obj({})
end
---@param obj HeartBeat.BeatRsp
function TBeatRsp:init_from_obj(obj)

end

function TBeatRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBeatRsp.group)
end

TBeatRsp.from_obj = TBeatRsp_from_obj

TBeatRsp.proto_property = {}

TBeatRsp.default = {}

TBeatRsp.struct = {}

function TBeatRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TBeatRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBeatRsp.proto_property, errs, need_convert)
    return self
end

function TBeatRsp:unpack(_)
end

HeartBeat.BeatRsp = TBeatRsp

---@class HeartBeat.BeatReq
local TBeatReq = {}
TBeatReq.__index = TBeatReq
TBeatReq.group = {}

local function TBeatReq_from_obj(obj)
    return setmetatable(obj, TBeatReq)
end

function TBeatReq.new()
    return TBeatReq_from_obj({})
end
---@param obj HeartBeat.BeatReq
function TBeatReq:init_from_obj(obj)

end

function TBeatReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBeatReq.group)
end

TBeatReq.from_obj = TBeatReq_from_obj

TBeatReq.proto_property = {}

TBeatReq.default = {}

TBeatReq.struct = {}

function TBeatReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TBeatReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBeatReq.proto_property, errs, need_convert)
    return self
end

function TBeatReq:unpack(_)
end

HeartBeat.BeatReq = TBeatReq

HeartBeat.interface = mdb.register_interface('bmc.kepler.Managers.HeartBeat', {
    Name = {'s', {}, true, nil, false},
    Status = {'s', {}, true, nil, false}
}, {Beat = {'a{ss}', '', TBeatReq, TBeatRsp}}, {})

return HeartBeat
