-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local Properties = require 'rack_mgmt.json_types.Properties'

---@class HeartBeatTable: Table
---@field Name FieldBase
---@field Status FieldBase
---@field ClassName FieldBase
---@field ObjectName FieldBase
---@field ObjectIdentifier FieldBase

---@class Rack_mgmtDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field HeartBeat HeartBeatTable
local Rack_mgmtDBDatabase = {}
Rack_mgmtDBDatabase.__index = Rack_mgmtDBDatabase

function Rack_mgmtDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.HeartBeat = db:Table('t_heart_beat', {
        Name = Col.TextField():cid(1):null(),
        Status = Col.TextField():cid(2):null(),
        ClassName = Col.TextField():cid(3):null(),
        ObjectName = Col.TextField():cid(4):null(),
        ObjectIdentifier = Col.JsonField():cid(5):null()
    }):create_if_not_exist(datas and datas['t_heart_beat'])

    obj.tables = db.tables
    return setmetatable(obj, Rack_mgmtDBDatabase)
end

function Rack_mgmtDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function Rack_mgmtDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function Rack_mgmtDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function Rack_mgmtDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function Rack_mgmtDBDatabase:exec(...)
    return self.db:exec(...)
end

return Rack_mgmtDBDatabase.new
