-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local app_base = require 'mc.client_app_base'
local log = require 'mc.logging'
local class = require 'mc.class'
local org_freedesktop_dbus = require 'sd_bus.org_freedesktop_dbus'
local MatchRule = org_freedesktop_dbus.MatchRule
local mdb = require 'mc.mdb'
local mdb_service = require 'mc.mdb.mdb_service'
local subscribe_signal = require 'mc.mdb.subscribe_signal'

local get_virtual_interface_object = mdb_service.get_virtual_interface_object
local get_non_virtual_interface_objects = mdb_service.get_non_virtual_interface_objects
local foreach_non_virtual_interface_objects = mdb_service.foreach_non_virtual_interface_objects

---@class rack_mgmt_client: BasicClient
local rack_mgmt_client = class(app_base.Client)

rack_mgmt_client.subscriptions = {}
function rack_mgmt_client:SubscribeAll()
    if self.has_subscribe_all then
        return
    end

    for i = 1, #self.subscriptions do
        self.subscriptions[i](self)
    end

    self.has_subscribe_all = true
end

function rack_mgmt_client:ctor()
    self.signal_slots = {}
end

---@type rack_mgmt_client
return rack_mgmt_client.new('rack_mgmt')
