# rack_mgmt 机柜管理

## 功能简介:
**rack_mgmt** 主要负责机柜节点的管理功能，具体管理功能有：
- 节点U位管理：根据柜内交换机的LLDP报文，以及交换机的节点配置，获取对应的U位
- 交换机信息管理：根据交换机的LLDP报文，生成对应的交换机的信息
- 节点心跳管理：根据节点和iRM的通信，维护心跳以及心跳状态
- 节点网络管理：心跳丢失和端口link状态变更之后的网络策略管理
<br>

**rack_mgmt** 由于组网较为复杂，网络部分和平台子系统 **bmc_network** 交互比较频繁，二者的业务能力划分如下：

> **bmc_network 组件提供如下能力**
> - 交换机的LLDP信息解析是网络的通用能力
> - 交换机组网的装备测试是装备网络通用能力
> - 交换机信息查询Redfish接口在网络（URI确定）
> - 内网（网口组）管理（IPPolicy: 1 - Slot; 2 - ...）
> - 网口切换是网络的通用能力
<br>

> **rack_mgmt 组件提供如下能力**
> - 使用交换机信息解析槽位是rack产品特性
> - iRM和节点之间的心跳是rack产品特性
> - 心跳/link等状态原因需要切换网口是rack产品特性


## 关键特性：
### 1 rack_mgmt 组件交互设计

**rack** 是一个比较复杂的组网产品，全景组件交互概览图如下：

```plantuml
@startuml rack_mgmt总体交互
actor "运维" as maintainer
actor "网管\n用户\n生产装备" as user
actor "柜内交换机" as inner
participant "bmc_network" as network
actor "资源树" as resource
participant "rack_mgmt" as rack
actor "柜外交换机" as outer
actor "iRM管理" as irm

== U位&交换机&内网处理 ==
inner -> network: 发送 LLDP 报文
outer -> network: 发送 LLDP 报文
network -> network: 解析 LLDP 报文
network -> resource: 维护 LLDP 信息 <with Mac>
rack -> resource: 更新 NodeLocation 信息
network -> network: 内网处理
network -> resource: 维护内网信息
network -> resource: 维护交换机信息 <with Mac>
rack -> resource: 更新交换机信息

== 心跳&网口处理 ==
rack -> rack: 内网监控处理
irm -> rack: 发送心跳信息
rack -> rack: 心跳处理
rack -> resource: 维护心跳信息
rack -> network: 切换网口处理

== 运维接口处理 ==
maintainer -> network: 运维网口设置请求
network -> maintainer: 运维网口设置响应

== 用户接口处理 ==
user -> network: 查询交换机信息请求
user -> network: 装备交换机测试请求
network -> network: 交换机信息处理
network -> resource: 交换机测试结果
resource -> user: 查询交换机信息响应\n装备交换机测试响应 
@enduml
```

由于用户接口整体都在平台子系统 **bmc_network** 出具，因此 **rack_mgmt** 的交互重点设计为如下两部分：
- U位和交换机信息管理交互
- 心跳和网络管理交互
<br>

#### 1.1 U位和交换机信息管理交互设计

```plantuml
@startuml 交换机&U位信息管理
actor "柜内交换机" as inner
participant "bmc_network" as network
actor "资源树" as resource
participant "rack_mgmt" as rack
actor "柜外交换机" as outer

inner -> network: 发送LLDP报文
network -> network: 解析LLDP报文\n生成LLDP信息
network -> resource: 发布LLDP信息<Mac>
note left of resource
    - PortName <s>
    - PortDesc <s>
    - SysDesc <s>
    - OrgSpec <s>
    - MgmtAddr <s>
    - Mac <s>
end note
resource -> rack: signal<Added/Changed>
rack -> rack: 交换机配置映射端口处理
note right of rack
    交换机配置列表
    - DX112
    - HUAWEI DX111
    - ...
end note
rack -> resource: 更新 NodeLocation <Mac>
network -> resource: 发布交换机信息<Mac>
note left of resource
    - Ports <as>
end note
rack -> resource: 更新 SwitchInfo <Mac>
resource -> network: signal<Changed>
network -> network: 生成内网地址\n{IPPolicy: Slot}

outer -> network: network: 发送LLDP报文
network -> network: 解析LLDP报文\n生成LLDP信息
network -> resource: 发布LLDP信息<Mac>
note left of resource
    - PortName <s>
    - PortDesc <s>
    - SysDesc <s>
    - OrgSpec <s>
    - MgmtAddr <s>
    - Mac <s>
end note
resource -> rack: signal<Added/Changed>
rack -> rack: 交换机配置映射端口处理\n映射失败则直接丢弃消息
note right of rack
    交换机配置列表
    - DX112
    - HUAWEI DX111
    - ...
end note
@enduml
```

#### 1.2 心跳管理交互设计

```plantuml
@startuml rack_mgmt心跳交互
participant "bmc_network" as network
actor "资源树" as resource
participant "rack_mgmt" as rack
actor "iRM管理" as irm

rack -> resource: 获取内网网段
rack -> resource: iRM心跳状态
rack -> rack: 内网监控处理
alt link状态为Connected
    rack -> rack: 失败次数清零
else 失败
    rack -> rack: 失败次数累积
    loop 2次
        rack -> network: 切换下一个网口
    end
end

irm -> rack: 心跳/redfish/v1
alt 心跳ClientIP匹配内网
    rack -> rack: 更新心跳时间戳
else 不匹配
    alt 心跳时间戳大于30s
        alt ping一次内网不通
            rack -> resource: 心跳更新为Lost
            rack -> network: 切换下一个网口
        else ping通内网
            rack -> rack: 更新心跳时间戳
        end
    end
end
@enduml
```

## 对外接口

### 资源树接口

- HeartBeat
  Path: /bmc/kepler/Managers/:ManagerId/HeartBeat/${Id}
  Interface: bmc.kepler.Managers.HeartBeat

| 属性 | 描述 | 
| :-----: | :---- |
| Name | 监控心跳的实体名称 |
| Status | 心跳状态 |

### IPMI接口
不涉及

## 配置介绍
不涉及
