# Profile Schema(配置导入导出schema文件管理)
- 组件类型：配置类（configuration）
- 组件作用：
  - 承载各组件配置导入导出数据模型定义
  - 承载各组件定制化数据模型定义

# 目录

[1 代码仓目的](#jump1)

[2 代码仓结构](#jump2)

[3 schema文件详细介绍](#jump3)

[4 支持的标准schema规则](#jump4)

[5 部署后的schema校验流程](#jump5)

[6 组件schema中属性命名规则](#jump6)

## <span id="jump1">1 代码仓目的</span>

schema文件用于承载组件配置导入导出的数据模型（属性定义+取值约束），由于配置导入导出的属性直接面向用户，因此作为组件对外接口的一部分。组件在schema仓实现数据定义后即可借助配置导入导出统一的校验机制实现对用户数据数据的校验（该能力由oms组件实现）。

## <span id="jump2">2 代码仓结构</span>

组件开发人员上库时按照自身的组件名称对schema文件进行命名，上库到本仓的**schema**目录下

```shell
.
├── CHANGELOG.md         # 记录本仓的变更信息
├── CMakeLists.txt       # 构建配置，主要定义schema的安装路径
├── README.md            # 代码仓说明
├── build.py             # 构建脚本
├── conanfile.py
├── conaninfo.py
├── mds
│   └── service.json     # 主要定义本仓的版本号
├── permissions.ini      # 构建权限管理文件
├── schema               # 主目录，存放组件的schema文件
│   ├── bios.json        # 组件schema文件，以组件名进行命名，每个组件分别定义一个schema
│   ├── iam.json
│   └── ...
└── test                 # 测试目录
```

## <span id="jump3">3 schema文件详细介绍</span>


**标准schema关键字：**

* type：json schema 的数据类型

* properties：json schema 对象属性键值对

**固定名称的属性：**

* Description：固定属性，组件描述字段

* ConfigData：固定属性，组件配置数据字段

**组件自定义数据集合名称：**

* Accounts(示例)：组件自定义属性名称

**扩展的关键字：**

* AttributeType：配置数据实例对应属性的类型
  * ExportOnly：仅支持导出;
  * ImportAndExport：支持导入和导出;

* HideValue：组件导出数据时，是否需要隐藏value。
  * 为true时属性取值为"\*\*\****”，表示对该属性值进行隐藏。
  * 组件schema中不设置该值时，导出文件中默认不隐藏value。

* Import：设置导出后的Import默认值
  * 仅AttributeType为ImportAndExport可以配置该字段，true表示当前属性需要导入（不设置时默认为true），false表示不需要导入。
  * 该功能类似于xml中的注释功能，false对应于对导入属性进行“注释”，导入时不生效该属性。

* CustomSettings: 定制化属性对象集合


组件schema示例：

```json
{
    "type": "object",
    "properties": {
        "Description": {
            "const": "Configurations of fault_daignosis"
        },
        "ConfigData": {
            "type": "object",
            "properties": {
                "FDMService": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "SystemId": {
                                "type": "number",
                                "AttributeType": "ImportAndExport"
                            },
                            "UnknownCaterrPolicy": {
                                "type": "string",
                                "AttributeType": "ImportAndExport",
                                "enum": ["NoAction", "Reset", "PowerOff"]
                            },
                            "IdentifiedCaterrPolicy": {
                                "type": "string",
                                "AttributeType": "ImportAndExport",
                                "enum": ["NoAction", "Reset"]
                            }
                        }
                    }
                },
                "CustomSettings": {
                    "type": "object",
                    "properties": {
                        "BMCSet_FDMIErrWarmResetEnable": {
                            "type": "number",
                            "AttributeType": "ImportAndExport",
                            "enum": [0, 1, 2],
                            "CustomDefault": 1
                        }
                    }
                }
            }
        }
    }
}
```

## <span id="jump4">4 支持的标准schema规则</span>

当前由oms组件实现了schema规则，用于配置数据统一校验。当前仅支持部分标准schema规则，后续会结合组件诉求进行扩展，已支持的标准schema规则如下：

* 数据类型：integer、number、string、boolean、array、object、null

* 字符串长度：minLength、maxLength

* 正则表达式（字符串） ：pattern

* 枚举值：enum

* 常量值: const

* 数组长度： minItems、maxItems

* 属性数量： minProperties、 maxProperties

* 必须属性： required

* 额外属性： additionalProperties

* 属性名称： propertyNames

* 数字的范围： minimum、 maximum

* 排他范围： exclusiveMinimum、 exclusiveMaximum

* 唯一性： uniqueItems


## <span id="jump5">5 部署后的schema校验流程</span>

经过部署后，profile_schema代码仓所有组件的schema文件将被安装到BMC环境的只读目录（当前为：/opt/bmc/profile_schema）。组件进行配置导入时，oms组件负责加载schema并对用户导入的配置数据进行校验，并将校验通过的schema文件下发给对应组件进行导入。配置导出时不做校验。

![image-20230522152550247](http://image.huawei.com/tiny-lts/v1/images/7de08e0b2c1c32fe65f32d95211ae8bb_924x450.png@900-0-90-f.png)


## <span id="jump6">6 组件schema中属性命名规则</span>


由于需要基础V2配置导入导出类（可以看作配置集合）和属性的名称，经SEG讨论，命名规则如下：

**命名规则：**

1、优先与V2配置集合、属性名称保持一致；

2、其次采用V3资源树的定义；

3、最后采用自定义名称；

参考：iBMC V2用户指南《**配置文件说明**》章节


**评审规则：**

1、由于schema中定义的导入导出的属性关键字对最终用户可见，为了确保用户侧名称符合规范，因此需要在上库前进行评审；

2、组件开发人员在上库profile_schema仓库之前需要**上报议题到资源树评审会议**，确保评审通过；

3、与V2保持一致的属性（使用V2属性名称或在组件内部通过转换保持一致），不需要评审。