local lu = require 'luaunit'
local c_psu_object = require 'device.psu'
local client = require 'power_mgmt.client'
local c_efficiency_curve_object = require 'efficiency_curve'
local custom_msg = require 'messages.custom'

local RET_OK <const> = 0
local RET_ERR <const> = -1

local common_ret = RET_ERR

TestPsu = {}

function TestPsu:test_psu_firmware_register()
    function client:PFirmwareInventoryFirmwareInventoryAdd(ctx, FirmwareInfoTable, ...)
        if FirmwareInfoTable.Id == 'EXU_PSU1' then
            common_ret = RET_OK
        end
    end

    c_psu_object.DeviceLocator = 'PowerConverter1'
    c_psu_object.Position = 'EXU'
    c_psu_object.Model = 'qb900'
    c_psu_object.Manufacturer = 'huawei'
    c_psu_object:register_fw_info()
    lu.assertEquals(common_ret, RET_OK)
end

function TestPsu:test_psu_power_level()
    c_psu_object.position = "01010B"
    c_psu_object.PartNumber = "02313FNC"
    c_psu_object.PowerLevel = "N/A"
    c_efficiency_curve_object.collection.fold = function(...)
        if c_psu_object.position == "010109" and c_psu_object.PartNumber == "02313FNC" then
            c_psu_object.PowerLevel = "80PLUS Platinum"
        end
    end
    c_psu_object.update_power_level(c_psu_object)
    lu.assertEquals(c_psu_object.PowerLevel, "N/A")

    c_psu_object.position = "010109"
    c_efficiency_curve_object.collection.fold = function(...)
        if c_psu_object.position == "010109" and c_psu_object.PartNumber == "02313FNC" then
            c_psu_object.PowerLevel = "80PLUS Platinum"
        end
    end
    c_psu_object.update_power_level(c_psu_object)
    lu.assertEquals(c_psu_object.PowerLevel, "80PLUS Platinum")
    
    c_psu_object.PowerLevel = "80PLUS"
    c_psu_object.update_power_level(c_psu_object)
    lu.assertEquals(c_psu_object.PowerLevel, "80PLUS")
end

function TestPsu:test_update_efficiency_curve()
    c_psu_object.position = "010109"
    c_psu_object.PartNumber = "02313FNC"
    c_psu_object.InputVoltage = 220
    c_psu_object.PowerLevel = "80PLUS Platinum"
    c_efficiency_curve_object.collection.find = function(...)
           return { PowerLevel = "80PLUS Platinum" }
        end
    c_psu_object.update_efficiency_curve(c_psu_object)
    lu.assertEquals(c_psu_object.PowerLevel, "80PLUS Platinum")
end

function TestPsu:test_is_attribute_mismatch()
    local power_mgmt_app = require "power_mgmt_app"
    lu.assertEquals(power_mgmt_app ~= nil, true)
    c_psu_object.power_mgmt_instance = require 'device.power_mgmt'.new()
    local obj = {
        ["IsManufacturerMismatch"] = false,
        ["IsModelMismatch"] = false
    }
    c_psu_object.power_mgmt_instance:set_obj(obj)
    c_psu_object.power_mgmt_instance:set_value("IsManufacturerMismatch", false)
    c_psu_object.Manufacturer = "Huawei"
    ans = c_psu_object.is_attribute_mismatch(c_psu_object, "Manufacturer")
    c_psu_object.is_mismatch(c_psu_object)
    lu.assertEquals(ans, false)
    c_psu_object.power_mgmt_instance:set_obj(nil)
end

function TestPsu:test_set_psu_fan_rpm_2()
    c_psu_object.Cooling = {}
    c_psu_object.Cooling.methods = {}
    c_psu_object.Cooling.methods.SetFanRPM = function ()
        error('set failed')
    end
    local res = pcall(function ()
        return c_psu_object.set_psu_fan_rpm(c_psu_object)
    end)
    lu.assertEquals(res, true)
end

function TestPsu:test_get_psu_fan_rpm_1()
    c_psu_object.Cooling = {}
    c_psu_object.Cooling.methods = {}
    c_psu_object.Cooling.methods.GetFanRPM = function ()
        return 10
    end
    local res = c_psu_object.get_psu_fan_rpm(c_psu_object)
    lu.assertEquals(res, 10)
end

function TestPsu:test_get_psu_fan_rpm_2()
    c_psu_object.Cooling = {}
    c_psu_object.Cooling.methods = {}
    c_psu_object.Cooling.methods.GetFanRPM = function ()
        error('get failed')
    end
    local res = pcall(function ()
        return c_psu_object.get_psu_fan_rpm(c_psu_object)
    end)
    lu.assertEquals(res, false)
end

function TestPsu:test_get_psu_register_info_1()
    c_psu_object.Power = {}
    c_psu_object.Power.methods = {}
    c_psu_object.Power.methods.GetPsuRegisterInfo = function ()
        return 10
    end
    local res = c_psu_object.get_psu_register_info(c_psu_object)
    lu.assertEquals(res, 10)
end

function TestPsu:test_get_psu_register_info_2()
    c_psu_object.Power = {}
    c_psu_object.Power.methods = {}
    c_psu_object.Power.methods.GetPsuRegisterInfo = function ()
        error('get failed')
    end
    local res, rsp = pcall(function ()
        return c_psu_object.get_psu_register_info(c_psu_object)
    end)
    lu.assertEquals(res, false)
    lu.assertEquals(rsp, custom_msg.OperationFailed())
end

function TestPsu:test_update_firmware()
    function c_psu_object.update_firmware_info(c_psu_object)
        return true
    end
    c_psu_object.ps_id = 1
    c_psu_object.last_firmware_version = "DC:106 PFC:106"
    c_psu_object.FirmwareVersion = "DC:108 PFC:108"
    c_psu_object.update_firmware(c_psu_object)
    lu.assertEquals(c_psu_object.last_firmware_version, "DC:108 PFC:108")
end