-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local utils = require 'power_mgmt_utils'
local power_upgrade = (require 'power_upgrade').get_instance()
local file_sec = require 'utils.file'
local utils_core = require 'utils.core'
local c_psu_object = require 'device.psu'
local c_power_configuration = require 'device.power_configuration'
local signal = require 'signal'
local client = require 'power_mgmt.client'
local c_power_supplies_object = require 'device.power_supplies'

TestPowerUpgrade = {}
utils.cfgs.cfgs = {{component_idex = 2}}
utils.secure_tar_unzip = function () return true end

c_power_configuration.collection.find = function ()end
c_power_supplies_object.collection.find = function ()end

local f_log = file_sec.open_s('/root/test_upgrade', 'w+')
utils.close(f_log, pcall(f_log.write, f_log, 'xxx'))

client.PFileFileChown = function() return true end
client.UpdateServiceUpdateServicePrepareReply = function () end
client.UpdateServiceUpdateServiceProcessReply = function () end
client.UpdateServiceUpdateServiceFinishReply = function () end

function TestPowerUpgrade:test_prepare()
    local ok = pcall(function ()
        power_upgrade.prepare_upgrade(1, 'Power', '/root/test_upgrade', '', {})
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_procesee()
    local ok = pcall(function ()
        power_upgrade.process_upgrade(nil, 1, 'Power', '/root/test_upgrade', {})
    end)
    lu.assertTrue(ok)

    local ok = pcall(function ()
        power_upgrade.process_upgrade(nil, 1, 'Non', '/root/test_upgrade', {})
    end)
    lu.assertTrue(ok)

    utils.cfgs.cfgs = {{component_idex = 0x7D}}
    local ok = pcall(function ()
        power_upgrade.process_upgrade(nil, 1, 'Power', '/root/test_upgrade', {})
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_finish()
    utils.get_instance().get_update_cfg_firmware_version = function ()
        return 1
    end
    utils.get_instance().get_upgrade_psu_objs = function ()
        local psu_objs = {
            {ps_id = 1, FirmwareVersion = 1},
            {ps_id = 2, FirmwareVersion = 2}
        }
        return psu_objs
    end
    local ok = pcall(function ()
        power_upgrade.finish_upgrade(1, 'Power', {})
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_upgrade_check()
    local ok = pcall(function ()
        power_upgrade.upgrade_power_process(1, 'Power', '/root/test_upgrade', 0)
    end)
    lu.assertTrue(ok)
    ok = pcall(function ()
        c_psu_object:power_upgrade()
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_signal()
    local ok = pcall(function ()
        signal.upgrade_prepare_callback()
    end)
    lu.assertTrue(ok)

    ok = pcall(function ()
        signal.upgrade_process_callback()
    end)
    lu.assertTrue(ok)

    ok = pcall(function ()
        signal.upgrade_finish_callback()
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_upgrade_status_check()
    local tab = {}
    local res = c_power_supplies_object.get_upgrade_status(tab)
    lu.assertEquals(res, nil)
end

function TestPowerUpgrade:test_set_upgrade_status_check()
    local tab = {}
    local upgrade_status = 1
    local res = c_power_supplies_object.set_upgrade_status(tab, upgrade_status)
    lu.assertEquals(res, nil)
end