-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local metric_collect = require 'metric_collect'

local PSU_POWER <const> = 'psu.power'
local PSU_POWEROUT <const> = 'psu.powerout'

TestMetricCollect = {}

function TestMetricCollect:test_get_psu_data_collection_data()
    psu1 = {path = 1}
    ans1 = metric_collect.get_psu_data_collection_data(metric_collect, psu1, {PSU_POWER, PSU_POWEROUT})
    lu.assertEquals(ans1[1]['Data'][1], '88')    
    lu.assertEquals(ans1[2]['Data'][1], '66')
    psu2 = {path = 2}
    ans2 = metric_collect.get_psu_data_collection_data(metric_collect, psu2, {PSU_POWER, PSU_POWEROUT})
    lu.assertEquals(#ans2, 0)
end