-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local enums = require 'macros.power_mgmt_enums'
local lock_chip = (require 'lock_chip').get_instance()

TestLockChip = {}

function TestLockChip:test_lock()
    local tmp = {}
    local ok1, _ = pcall(function()
        return lock_chip.lock(tmp, nil, 300)
    end)
    lu.assertEquals(ok1, false)
    local chip = {
        LockStatus = 1
    }
    local ok2, result2 = pcall(function()
        return lock_chip.lock(tmp, chip, 300)
    end)
    lu.assertEquals(ok2, true)
    lu.assertEquals(result2, 0)
    chip = {
        SetLockStatus = function()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end
    }
    local ok3, result3 = pcall(function()
        return lock_chip.lock(tmp, chip, 300)
    end)
    lu.assertEquals(ok3, true)
    lu.assertEquals(result3, -1)
    chip.LockStatus = 0
    local ok4, result4 = pcall(function()
        return lock_chip.lock(tmp, chip, 300)
    end)
    lu.assertEquals(ok4, true)
    lu.assertEquals(result4, enums.LOCK_RESULT_CODE.SUCCESS)
end

function TestLockChip:test_retry_lock_chip()
    local tmp = {
        lock = function()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end
    }
    local chip = {
        SetLockStatus = function ()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end,
        LockStatus = 0
    }
    local ok = pcall(function()
        return lock_chip.retry_lock_chip(tmp, chip)
    end)
    lu.assertEquals(ok, true)
end

function TestLockChip:test_unlock()
    local tmp = {}
    local ok1, _ = pcall(function()
        return lock_chip.unlock(tmp, nil)
    end)
    lu.assertEquals(ok1, false)
    local chip = {
        LockStatus = 0
    }
    local ok2, result2 = pcall(function()
        return lock_chip.unlock(tmp, chip)
    end)
    lu.assertEquals(ok2, true)
    lu.assertEquals(result2, 0)
    chip = {
        SetLockStatus = function()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end
    }
    local ok3, result3 = pcall(function()
        return lock_chip.unlock(tmp, chip)
    end)
    lu.assertEquals(ok3, true)
    lu.assertEquals(result3, -1)
    chip.LockStatus = 1
    local ok4, result4 = pcall(function()
        return lock_chip.unlock(tmp, chip)
    end)
    lu.assertEquals(ok4, true)
    lu.assertEquals(result4, enums.LOCK_RESULT_CODE.SUCCESS)
end

function TestLockChip:test_retry_unlock_chip()
    local tmp = {
        unlock = function()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end
    }
    local chip = {
        SetLockStatus = function ()
            return enums.LOCK_RESULT_CODE.SUCCESS
        end,
        LockStatus = 1
    }
    local ok = pcall(function()
        return lock_chip.retry_unlock_chip(tmp, chip)
    end)
    lu.assertEquals(ok, true)
end