-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: power_mgmt RPC methods

loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()

local utils = require 'utils.core'
local mc_utils = require 'mc.utils'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

-- 增加mock文件路径
local test_dir = mc_utils.realpath('.')
package.path = test_dir .. '/mock/?.lua;' .. package.path 

require 'test_pmbus'
require 'test_pmbus_qb900'
require 'test_power_upgrade'
require 'test_export_import'
require 'test_psu'
require 'test_log_serivce'
require 'test_power_mgmt_utils'
require 'test_lock_chip'
require 'test_metric_collect'
require 'test_init'
require 'test_power_mgmt_app'

os.exit(lu.LuaUnit.run())
