-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

local skynet = {['thread_table'] = {}, ['thread_id'] = 1}

function skynet.fork(...)
    local thread_id = 'thread' .. skynet.thread_id
    skynet.thread_id = skynet.thread_id + 1
    skynet.thread_table[thread_id] = true
    return thread_id
end

function skynet.wait(...)
end

function skynet.wakeup(...)
end

function skynet.sleep(...)
end

function skynet.fork_once()
end

function skynet.killthread(id)
    if not id then
        return
    end
    lu.assertTrue(skynet.thread_table[id])
    skynet.thread_table[id] = nil
end

function skynet.register_protocol(...)
end

function skynet.dispatch(...)
end

skynet.getenv = function()
    return 400
end

return skynet