-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 装备测试集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local context = require'mc.context'

require 'power_mgmt.json_types.Manufacture'
local test_manufacture = {}

local DFTPOWERSUPPLY_PATH = '/bmc/kepler/Manufacture/SelfTest/DftPowerSupply'
local DFT_INTERFACE = 'bmc.kepler.Manufacture'

-- 测试装备项 DftPmu
local function test_dft_powersupply(bus)
    local objs = mdb.get_sub_objects(bus, DFTPOWERSUPPLY_PATH, DFT_INTERFACE)
    local _, obj = next(objs)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Testing")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description,
        "SLOT:1-VIN:229.00SLOT:2-VIN:222.00")
    log:info('- test dft powersupply finish')
end

function test_manufacture.test_all_dft_method(bus)
    test_dft_powersupply(bus)
end

return test_manufacture
