-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local singleton = require 'mc.singleton'
local class = require 'mc.class'

local system_power = class()

function system_power:ctor(local_db)
    self.local_db = local_db
end

function system_power:init()
    local db_data = self.local_db:select(self.local_db.SystemPower):first()
    if not db_data then
        log:notice('Initializing the SystemPower database')
        db_data = self.local_db.SystemPower(
            {
                Id = 'SystemPower',
                PsuFruConfig = 0 -- 默认值
            }
        )
        db_data:save()
        log:notice('Initializing the SystemPower database')
    end
end

function system_power:get_psu_fru_config()
    local db_data = self.local_db:select(self.local_db.SystemPower):first()
    return db_data.PsuFruConfig
end

function system_power:set_psu_fru_config(value)
    local db_data = self.local_db.SystemPower(
        {
            Id = 'SystemPower',
            PsuFruConfig = value
        }
    )
    db_data:save()
end

return singleton(system_power)