-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

return {
    E_OK = nil, -- 函数执行成功返回nil
    E_FAILED = '', -- 空错误信息

    FRU_STATE_IGNORE  = 0,
    FRU_STATE_READING = 1,
    FRU_STATE_OK      = 2,

    DEV_STATE_PLUGOUT = 0,
    DEV_STATE_RUNNING = 1,
    DEV_STATE_ERROR   = 2,

    -- 无效值定义
    TASK_ID_INVALID    = 0xFF, -- 无效任务ID
    DEV_ID_INVALID     = 0xFF, -- 无效设备ID
    DEV_TYPE_INVALID   = 0xFF, -- 无效设备类型
    INT_VECTOR_INVALID = 0xFF, -- 无效中断向量

    INVALID_DATA = 0, -- 无效值

    RETRY_TIMES = 3,
    QUERY_INTERVAL = 20, -- 轮询时长200ms

    PRESENT = 1,
    NOT_PRESENT = 0,
    DEFAULT_PRESENT = 255,

    MAX_BLACK_BOX_NUMBER_PMBUS = 11,
    MAX_BLACK_BOX_BLOCK_NUMBER_CANBUS = 0x1D,
    MAX_BLACK_BOX_NUMBER_SMC = 8,

    TASK_CTRL_RUNNING = 1,
    TASK_CTRL_STOP = 0,

    IS_HEALTH = 0,
    IS_NOT_HEALTH = 0xff,

    PROTOCOL = {
        PSMI = 0,
        PMBUS = 1,
        CANBUS = 10
    },
    INTF = {
        ONEPOWER = 'bmc.kepler.Systems.PowerMgmt.OnePower',
        ONEPOWER_METRICS = 'bmc.kepler.Systems.PowerMgmt.OnePower.Metrics',
        ONEPOWER_TEMPERATURES = 'bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures',
        ONEPOWER_STATUS = 'bmc.kepler.Systems.PowerMgmt.OnePower.Status',
        PSUBLACKBOX = 'bmc.kepler.Debug.BlackBox'
    },
    PS_MONITOR = {
        VOUT_STATUS   = 0, -- 输出电压状态
        IOUT_STATUS   = 1, -- 输出电流状态
        VIN_STATUS    = 2, -- 输入电压状态
        TEMPER_STATUS = 3, -- 电源温度传感器的状态
        FAN_STATUS    = 4, -- 电源风扇的状态
        CML_STATUS    = 5, -- 命令的状态
        MFR_STATUS    = 6, -- 厂商自定义的状态

        PS_MONITOR_END = 7
    }
}