-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'

local power_configuration = c_object('PowerConfiguration')

function power_configuration:ctor()
    self.ps_id = self.SlotNumber
end

function power_configuration:get_single_ps_support_flag()
    if not self.SinglePsuSupport then
        return 0 -- 默认返回不支持
    end
    return self.SinglePsuSupport
end

function power_configuration.create_mdb_object()
end

function power_configuration:init()
    self:connect_signal(self.on_add_object_complete, function()
    end)
    power_configuration.super.init(self)
end

return power_configuration