-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

return {
    -- 升级阶段错误码:升级电源固件 201-219
    SUPPLY_0  = 0,
    SUPPLY_1  = 201,  -- 内部错误
    SUPPLY_2  = 202,  -- 升级条件检查失败,当前状态不支持升级
    SUPPLY_3  = 203,  -- 不支持升级,当前状态不支持升级
    SUPPLY_4  = 204,  -- 未升级
    SUPPLY_5  = 205,  -- 除升级电源外其他健康电源不能够支撑整机功率
    SUPPLY_6  = 206,  -- hpm和电源型号不匹配或者电源不支持升级
    SUPPLY_7  = 207,  -- 电源输入故障告警
    SUPPLY_8  = 208,  -- 电源模块ID重复告警
    SUPPLY_9  = 209,  -- 版本信息不一致
    SUPPLY_10 = 210,  -- 削峰填谷状态
    SUPPLY_11 = 211,  -- 个数小于2
    SUPPLY_12 = 212,  -- 电池放电状态
    SUPPLY_13 = 213,  -- 电池处于可放电健康状态个数少于2个

    FIRMWARE = {
        DCDC_SOFT = 0x80,
        PFC_SOFT  = 0x40,
        QB_SOFT   = 0x20
    },
    PATH_MAX = 4096,
    PS_SOFT_CNT = 3,
    MODULE_NUM_MAX = 2,
    SOFT_INFO_SIZE = 8,
    RETRY_INTERVAL = 500,
    ERASE_RETRY = 6,
    GET_RESULT_RETRY = 6,
    MAX_LOAD_POWER_INFO_RETRY_TIMES = 3,
    WAIT_MODULE_TIME = 10,
    NEGOTIATE_FRAME_LEN_RETRY = 6,

    -- 与firmware错误码对应
    ERROR_CODE = {
        CommonFinish = 0,
        FirmwareUpgradeError = 1,
        FileNotExist = 2,
        InvalidFirmwarePackage = 3,
        FirmwareFileMismatch = 12,
        FirmwarePackageVersionTooEarly = 33,
        FirmwareCannotUpgradeDuringPowerOn = 34,
        InsufficientPowerSupply = 205
    }
}
