-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local pmbus = require 'device_tree.adapters.power_mgmt.protocol.pmbus'
local psu_pmbus = class(pmbus)

function pmbus:get_linear_16(exponent, cmd) 
    return tonumber(string.format("%.2f", self:chip_wordread(cmd) / 4096))
end

-- get_output_voltage 输出电压
function pmbus:get_output_voltage()
    -- 先转换为整数与原先保持一致
    return tonumber(string.format("%d", self:get_linear_16(vout_mode, self.cmd.READ_12VOUT)))
end

return psu_pmbus