-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local base_content = 'device_tree.adapters.power_mgmt.protocol.'

local protocol = {
    -- 配置写法
    -- 1. physical_interface = {对外显示Protocol字段， require xxx文件, monitor的文件路径}
    -- 2. 厂商 = {
    --  [型号] = {对外显示Protocol字段， require xxx文件, monitor的文件路径}
    -- }

    -- 通用电源pmbus协议
    pmbus = { 'pmbus', require (base_content .. 'pmbus'), base_content .. 'monitor.pmbus' },
    -- 通用电源canbus协议
    canbus = { 'canbus', require (base_content .. 'canbus'), base_content .. 'monitor.canbus' },
    -- qb900电源砖pmbus协议，天工AI节点，电源砖功率不计入总功率
    pmbus_qb900 = {
        'pmbus', require (base_content .. 'pmbus_qb900'), base_content .. 'monitor.pmbus_qb900'
    },
    -- 电源pmbus协议，电源型号PDC3KD5412_LC，电源功率不计入总功率
    pmbus_PDC3KD5412_LC = { 'pmbus', require (base_content .. 'pmbus_PDC3KD5412_LC'),
                            base_content .. 'monitor.pmbus' },
    -- 电源pmbus协议，电源缓起板，电源型号IT22PEEA，延长电源信息获取轮训时间，电源功率计入总功率
    pmbus_IT22PEEA = { 'pmbus', require (base_content .. 'pmbus_PDC3KD5412_LC'),
                            base_content .. 'monitor.pmbus' },
    -- 电源pmbus协议，为了降低CPU占用率，延长电源信息获取轮训时间，电源功率计入总功率
    psu_pmbus = { 'pmbus', require (base_content .. 'pmbus_FP1420'), base_content .. 'monitor.pmbus' },
    -- 电源砖pmbus协议，为了降低CPU占用率，延长电源信息获取轮训时间，电源砖功率计入总功率
    powerconverter_pmbus = {
        'pmbus', require (base_content .. 'powerconverter_pmbus'), base_content .. 'monitor.powerconverter_pmbus'
    },
    -- 电源板，通过SMC协议获取电源信息
    smc = {'pmbus', require (base_content .. 'smc'), base_content .. 'monitor.pmbus'},
}

return function(physical_interface, manufacturer, model)
    local protocol_name, req_protocol, monitor
    if manufacturer and model and protocol[manufacturer] and protocol[manufacturer][model] then
        --  厂商 = {
        --  [型号] = {对外显示Protocol字段， require xxx文件}
        -- }
        protocol_name, req_protocol, monitor = table.unpack(protocol[manufacturer][model])
    else
        -- physical_interface = {对外显示Protocol字段， require xxx文件}
        protocol_name, req_protocol, monitor = table.unpack(protocol[physical_interface])
    end
    local func
    if monitor then
        -- 通用monitor
        local ok, resp = pcall(require, monitor)
        if ok then
            func = function (obj)
                return resp(obj)
            end
        end
    end
    return protocol_name, req_protocol, func
end
