-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local device_object = require 'mc.mdb.device_tree.device_object'
local log = require 'mc.logging'
local protocol = require 'device_tree.adapters.power_mgmt.protocol'
local fw_def = require 'device_tree.adapters.power_mgmt.protocol.upgrade.fw_def'

local psu = device_object('OnePower')

function psu:ctor()
    self.protocol = false
    self.ps_id = 0
    self.remote_power_monitor_task = false
    self.read_fail_count = 0
    self.remote_powe_signal = false
    self.last_read_interval = 10
    self.read_interval = 100
    self.is_upgrading = false
    self.monitor = false
    self.init_ok = false
    self.monitor_tasks = {}
end

function psu:init()
    self.ps_id = self.SlotNumber
    -- 电源升级
    self:declare_method('Upgrade', 'bmc.dev.psu.upgrade', 'Upgrade', function (...)
        return fw_def.SUPPLY_2
    end)
    self:declare_method('Cooling', 'bmc.dev.psu.cooling', 'SetFanRPM', function (...)
    end)
    self:declare_method('Cooling', 'bmc.dev.psu.cooling', 'GetFanRPM', function (...)
    end)
    self:declare_method('BlackBox', 'bmc.dev.psu.black_box', 'GetBlackBoxData', function ()
        return self:get_black_box_data()
    end)
    self:declare_method('PowerMode', 'bmc.dev.psu.power_mode', 'SetSleepMode', function (...)
    end)
    self:declare_method('PowerMode', 'bmc.dev.psu.power_mode', 'SetWorkMode', function (...)
    end)
    self:declare_method('Power', 'bmc.dev.psu', 'GetFruData', function (...)
    end)
    self:declare_method('Power', 'bmc.dev.psu', 'PowerAccessControl', function (...)
    end)
    self:declare_method('Power', 'bmc.dev.psu', 'UpdatePowerSupplyInfo', function (...)
    end)
end

function psu:is_present()
    return self.Presence == 1
end

function psu:sleep_time(upgrade_interval_time, time)
    if self.is_upgrading then
        self:sleep_ms(upgrade_interval_time)
    else
        self:sleep_ms(time)
    end
end

function psu:get_protocol(physical_interface)
    local protocol_name, req_protocol, monitor = protocol(physical_interface)
    if req_protocol then
        self.protocol = req_protocol.new(self, protocol_name)
    end
    if monitor then
        self.monitor = monitor(self)
    else
        log:warn('ps%d cannot find monitor, physical_interface = %s', self.ps_id, physical_interface)
    end
end

function psu:get_black_box_data()
    log:notice('get_black_box_data_smc start')
    local len, data = self.protocol:get_black_box_data()
    log:notice('get_black_box_data_smc end')
    return len, data
end

function psu:start()
    local ok, resp = pcall(function ()
        self:get_protocol(self.PhysicalInterface)
    end)
    if not ok then
        self.protocol = false
        self.monitor = false
        log:error('ps%s no protocol(%s). resp: %s', self.ps_id, self.PhysicalInterface, resp)
        return
    end
end

return psu