-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- DA123C节点 qb900电源砖
-- 电源砖信息从扩展板CPLD中获取，CSR中直接进行配置
-- 不支持设置冷休眠，设置电源主备模式，设置风扇转速
-- 不支持升级，黑匣子功能

local device_object = require 'mc.mdb.device_tree.device_object'
local log = require 'mc.logging'
local fw_def = require 'device_tree.adapters.power_mgmt.protocol.upgrade.fw_def'

local psu_slot = device_object('PsuSlot')

function psu_slot:ctor()
    self.last_present = false
    self.prop_cb = {}
    self.prop_value = {}
    self.ps_id = 0
    self.init_ok = false
end

function psu_slot:init()
    self.ps_id = self.SlotNumber
end

function psu_slot:is_present()
    return self.Presence == 1
end

function psu_slot:set_sleep_mode(sleep_mode)
    -- 不支持休眠模式，直接返回
    return
end

function psu_slot:set_work_mode(mode)
    -- 不支持主备切换，直接返回
    return
end

function psu_slot:set_psu_fan_rpm(mode)
    -- 不支持设置风扇转速，直接返回
    return
end

function psu_slot:get_psu_fan_rpm(mode)
    -- 不支持获取风扇转速，直接返回
    return
end

function psu_slot:get_psu_register_info(cmd, length)
    -- 不支持获取电源寄存器信息，直接返回
    return
end

function psu_slot:psm_monitor_stop()
    log:notice('ps%d power monitor stop', self.ps_id)
end

function psu_slot:power_upgrade()
    return fw_def.SUPPLY_2
end

function psu_slot:get_fru_data(value)
    return {}
end

function psu_slot:dal_refresh_property(prop, value)
    self.prop_value[prop] = value
    if not self.prop_cb[prop] then
        return
    end
    for _, cb in pairs(self.prop_cb[prop]) do
        if self.init_ok then
            self:next_tick(cb, value)
        else
            -- init阶段需要把属性刷新完才允许分发到app侧
            cb(value)
        end
    end
end

function psu_slot:fetch_power_supply_info(physical_interface)
    return
end

function psu_slot:clear_property_fetch_task()
    self.prop_cb = {}
    self.prop_value = {}
end

function psu_slot:fetch_property(prop, cb)
    if not self.prop_cb[prop] then
        self.prop_cb[prop] = {}
    end
    table.insert(self.prop_cb[prop], cb)
end

function psu_slot:power_monitor_start()
    log:notice('ps%d power monitor start', self.ps_id)
end

function psu_slot:get_black_box_data()
    log:notice('ps%d is not support black box', self.ps_id)
    return 0, ""
end

function psu_slot:start()
    self.last_present = self:is_present()
end

return psu_slot