-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PowerMgmt = {}

---@class PowerMgmt.IsModelMismatch
---@field IsModelMismatch boolean
local TIsModelMismatch = {}
TIsModelMismatch.__index = TIsModelMismatch
TIsModelMismatch.group = {}

local function TIsModelMismatch_from_obj(obj)
    return setmetatable(obj, TIsModelMismatch)
end

function TIsModelMismatch.new(IsModelMismatch)
    return TIsModelMismatch_from_obj({IsModelMismatch = IsModelMismatch})
end
---@param obj PowerMgmt.IsModelMismatch
function TIsModelMismatch:init_from_obj(obj)
    self.IsModelMismatch = obj.IsModelMismatch
end

function TIsModelMismatch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsModelMismatch.group)
end

TIsModelMismatch.from_obj = TIsModelMismatch_from_obj

TIsModelMismatch.proto_property = {'IsModelMismatch'}

TIsModelMismatch.default = {false}

TIsModelMismatch.struct = {{name = 'IsModelMismatch', is_array = false, struct = nil}}

function TIsModelMismatch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsModelMismatch', self.IsModelMismatch, 'bool', true, errs, need_convert)

    TIsModelMismatch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsModelMismatch.proto_property, errs, need_convert)
    return self
end

function TIsModelMismatch:unpack(_)
    return self.IsModelMismatch
end

PowerMgmt.IsModelMismatch = TIsModelMismatch

---@class PowerMgmt.IsManufacturerMismatch
---@field IsManufacturerMismatch boolean
local TIsManufacturerMismatch = {}
TIsManufacturerMismatch.__index = TIsManufacturerMismatch
TIsManufacturerMismatch.group = {}

local function TIsManufacturerMismatch_from_obj(obj)
    return setmetatable(obj, TIsManufacturerMismatch)
end

function TIsManufacturerMismatch.new(IsManufacturerMismatch)
    return TIsManufacturerMismatch_from_obj({IsManufacturerMismatch = IsManufacturerMismatch})
end
---@param obj PowerMgmt.IsManufacturerMismatch
function TIsManufacturerMismatch:init_from_obj(obj)
    self.IsManufacturerMismatch = obj.IsManufacturerMismatch
end

function TIsManufacturerMismatch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsManufacturerMismatch.group)
end

TIsManufacturerMismatch.from_obj = TIsManufacturerMismatch_from_obj

TIsManufacturerMismatch.proto_property = {'IsManufacturerMismatch'}

TIsManufacturerMismatch.default = {false}

TIsManufacturerMismatch.struct = {{name = 'IsManufacturerMismatch', is_array = false, struct = nil}}

function TIsManufacturerMismatch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsManufacturerMismatch', self.IsManufacturerMismatch, 'bool', true, errs, need_convert)

    TIsManufacturerMismatch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsManufacturerMismatch.proto_property, errs, need_convert)
    return self
end

function TIsManufacturerMismatch:unpack(_)
    return self.IsManufacturerMismatch
end

PowerMgmt.IsManufacturerMismatch = TIsManufacturerMismatch

PowerMgmt.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt', {
    IsManufacturerMismatch = {'b', {'EMIT_CHANGE'}, true, nil, false},
    IsModelMismatch = {'b', {'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return PowerMgmt
