-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BlackBox = {}

---@class BlackBox.DumpPsuBlackboxRsp
---@field TaskId integer
local TDumpPsuBlackboxRsp = {}
TDumpPsuBlackboxRsp.__index = TDumpPsuBlackboxRsp
TDumpPsuBlackboxRsp.group = {}

local function TDumpPsuBlackboxRsp_from_obj(obj)
    return setmetatable(obj, TDumpPsuBlackboxRsp)
end

function TDumpPsuBlackboxRsp.new(TaskId)
    return TDumpPsuBlackboxRsp_from_obj({TaskId = TaskId})
end
---@param obj BlackBox.DumpPsuBlackboxRsp
function TDumpPsuBlackboxRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpPsuBlackboxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpPsuBlackboxRsp.group)
end

TDumpPsuBlackboxRsp.from_obj = TDumpPsuBlackboxRsp_from_obj

TDumpPsuBlackboxRsp.proto_property = {'TaskId'}

TDumpPsuBlackboxRsp.default = {0}

TDumpPsuBlackboxRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpPsuBlackboxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDumpPsuBlackboxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpPsuBlackboxRsp.proto_property, errs, need_convert)
    return self
end

function TDumpPsuBlackboxRsp:unpack(_)
    return self.TaskId
end

BlackBox.DumpPsuBlackboxRsp = TDumpPsuBlackboxRsp

---@class BlackBox.DumpPsuBlackboxReq
local TDumpPsuBlackboxReq = {}
TDumpPsuBlackboxReq.__index = TDumpPsuBlackboxReq
TDumpPsuBlackboxReq.group = {}

local function TDumpPsuBlackboxReq_from_obj(obj)
    return setmetatable(obj, TDumpPsuBlackboxReq)
end

function TDumpPsuBlackboxReq.new()
    return TDumpPsuBlackboxReq_from_obj({})
end
---@param obj BlackBox.DumpPsuBlackboxReq
function TDumpPsuBlackboxReq:init_from_obj(obj)

end

function TDumpPsuBlackboxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpPsuBlackboxReq.group)
end

TDumpPsuBlackboxReq.from_obj = TDumpPsuBlackboxReq_from_obj

TDumpPsuBlackboxReq.proto_property = {}

TDumpPsuBlackboxReq.default = {}

TDumpPsuBlackboxReq.struct = {}

function TDumpPsuBlackboxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDumpPsuBlackboxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpPsuBlackboxReq.proto_property, errs, need_convert)
    return self
end

function TDumpPsuBlackboxReq:unpack(_)
end

BlackBox.DumpPsuBlackboxReq = TDumpPsuBlackboxReq

BlackBox.interface = mdb.register_interface('bmc.kepler.Debug.BlackBox', {}, {
    DumpPsuBlackbox = {'a{ss}', 'u', TDumpPsuBlackboxReq, TDumpPsuBlackboxRsp}
}, {})

return BlackBox
