--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPowerStatus = {}

---@class PowerMgmtIpmiCmds.SetPowerStatusReq
---@field ManufactureId integer
---@field PsSelector integer
---@field PsParameter integer
---@field Flag integer
---@field Offset integer
---@field Length integer
---@field Data string
local TSetPowerStatusReq = {}
TSetPowerStatusReq.__index = TSetPowerStatusReq
TSetPowerStatusReq.group = {}

local function TSetPowerStatusReq_from_obj(obj)
    return setmetatable(obj, TSetPowerStatusReq)
end

function TSetPowerStatusReq.new(ManufactureId, PsSelector, PsParameter, Flag, Offset, Length, Data)
    return TSetPowerStatusReq_from_obj({
        ManufactureId = ManufactureId,
        PsSelector = PsSelector,
        PsParameter = PsParameter,
        Flag = Flag,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj PowerMgmtIpmiCmds.SetPowerStatusReq
function TSetPowerStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.PsSelector = obj.PsSelector
    self.PsParameter = obj.PsParameter
    self.Flag = obj.Flag
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetPowerStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStatusReq.group)
end

TSetPowerStatusReq.from_obj = TSetPowerStatusReq_from_obj

TSetPowerStatusReq.proto_property = {'ManufactureId', 'PsSelector', 'PsParameter', 'Flag', 'Offset', 'Length', 'Data'}

TSetPowerStatusReq.default = {0, 0, 0, 0, 0, 0, ''}

TSetPowerStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'PsSelector', is_array = false, struct = nil},
    {name = 'PsParameter', is_array = false, struct = nil}, {name = 'Flag', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetPowerStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PsSelector', self.PsSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PsParameter', self.PsParameter, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Flag', self.Flag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetPowerStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerStatusReq:unpack(_)
    return self.ManufactureId, self.PsSelector, self.PsParameter, self.Flag, self.Offset, self.Length, self.Data
end

SetPowerStatus.SetPowerStatusReq = TSetPowerStatusReq

---@class PowerMgmtIpmiCmds.SetPowerStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetPowerStatusRsp = {}
TSetPowerStatusRsp.__index = TSetPowerStatusRsp
TSetPowerStatusRsp.group = {}

local function TSetPowerStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerStatusRsp)
end

function TSetPowerStatusRsp.new(CompletionCode, ManufactureId)
    return TSetPowerStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj PowerMgmtIpmiCmds.SetPowerStatusRsp
function TSetPowerStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetPowerStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStatusRsp.group)
end

TSetPowerStatusRsp.from_obj = TSetPowerStatusRsp_from_obj

TSetPowerStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetPowerStatusRsp.default = {0, 0}

TSetPowerStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetPowerStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetPowerStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetPowerStatus.SetPowerStatusRsp = TSetPowerStatusRsp

return SetPowerStatus
