--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingVoltageOutput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageOutputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingVoltageOutputReq = {}
TGetThresholdSensorReadingVoltageOutputReq.__index = TGetThresholdSensorReadingVoltageOutputReq
TGetThresholdSensorReadingVoltageOutputReq.group = {}

local function TGetThresholdSensorReadingVoltageOutputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingVoltageOutputReq)
end

function TGetThresholdSensorReadingVoltageOutputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingVoltageOutputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageOutputReq
function TGetThresholdSensorReadingVoltageOutputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingVoltageOutputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingVoltageOutputReq.group)
end

TGetThresholdSensorReadingVoltageOutputReq.from_obj = TGetThresholdSensorReadingVoltageOutputReq_from_obj

TGetThresholdSensorReadingVoltageOutputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingVoltageOutputReq.default = {0, 0}

TGetThresholdSensorReadingVoltageOutputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingVoltageOutputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingVoltageOutputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingVoltageOutputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingVoltageOutputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingVoltageOutput.GetThresholdSensorReadingVoltageOutputReq =
    TGetThresholdSensorReadingVoltageOutputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageOutputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingVoltageOutputRsp = {}
TGetThresholdSensorReadingVoltageOutputRsp.__index = TGetThresholdSensorReadingVoltageOutputRsp
TGetThresholdSensorReadingVoltageOutputRsp.group = {}

local function TGetThresholdSensorReadingVoltageOutputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingVoltageOutputRsp)
end

function TGetThresholdSensorReadingVoltageOutputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingVoltageOutputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageOutputRsp
function TGetThresholdSensorReadingVoltageOutputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingVoltageOutputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingVoltageOutputRsp.group)
end

TGetThresholdSensorReadingVoltageOutputRsp.from_obj = TGetThresholdSensorReadingVoltageOutputRsp_from_obj

TGetThresholdSensorReadingVoltageOutputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingVoltageOutputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingVoltageOutputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingVoltageOutputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingVoltageOutputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingVoltageOutputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingVoltageOutputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingVoltageOutput.GetThresholdSensorReadingVoltageOutputRsp =
    TGetThresholdSensorReadingVoltageOutputRsp

return GetThresholdSensorReadingVoltageOutput
