--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingCurrentOutput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentOutputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingCurrentOutputReq = {}
TGetThresholdSensorReadingCurrentOutputReq.__index = TGetThresholdSensorReadingCurrentOutputReq
TGetThresholdSensorReadingCurrentOutputReq.group = {}

local function TGetThresholdSensorReadingCurrentOutputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingCurrentOutputReq)
end

function TGetThresholdSensorReadingCurrentOutputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingCurrentOutputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentOutputReq
function TGetThresholdSensorReadingCurrentOutputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingCurrentOutputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingCurrentOutputReq.group)
end

TGetThresholdSensorReadingCurrentOutputReq.from_obj = TGetThresholdSensorReadingCurrentOutputReq_from_obj

TGetThresholdSensorReadingCurrentOutputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingCurrentOutputReq.default = {0, 0}

TGetThresholdSensorReadingCurrentOutputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingCurrentOutputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingCurrentOutputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingCurrentOutputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingCurrentOutputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingCurrentOutput.GetThresholdSensorReadingCurrentOutputReq =
    TGetThresholdSensorReadingCurrentOutputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentOutputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingCurrentOutputRsp = {}
TGetThresholdSensorReadingCurrentOutputRsp.__index = TGetThresholdSensorReadingCurrentOutputRsp
TGetThresholdSensorReadingCurrentOutputRsp.group = {}

local function TGetThresholdSensorReadingCurrentOutputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingCurrentOutputRsp)
end

function TGetThresholdSensorReadingCurrentOutputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingCurrentOutputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentOutputRsp
function TGetThresholdSensorReadingCurrentOutputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingCurrentOutputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingCurrentOutputRsp.group)
end

TGetThresholdSensorReadingCurrentOutputRsp.from_obj = TGetThresholdSensorReadingCurrentOutputRsp_from_obj

TGetThresholdSensorReadingCurrentOutputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingCurrentOutputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingCurrentOutputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingCurrentOutputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingCurrentOutputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingCurrentOutputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingCurrentOutputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingCurrentOutput.GetThresholdSensorReadingCurrentOutputRsp =
    TGetThresholdSensorReadingCurrentOutputRsp

return GetThresholdSensorReadingCurrentOutput
